/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.DefaultDocumentFieldValue;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentFieldConverter;
import org.jnosql.artemis.document.DocumentFieldConverters;
import org.jnosql.artemis.document.DocumentFieldValue;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.artemis.reflection.FieldType;
import org.jnosql.artemis.reflection.FieldValue;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentEntity;

public abstract class AbstractDocumentEntityConverter
implements DocumentEntityConverter {
    private final DocumentFieldConverters.DocumentFieldConverterFactory converterFactory = new DocumentFieldConverters.DocumentFieldConverterFactory();

    protected abstract ClassMappings getClassMappings();

    protected abstract Converters getConverters();

    @Override
    public DocumentEntity toDocument(Object entityInstance) {
        Objects.requireNonNull(entityInstance, "Object is required");
        ClassMapping mapping = this.getClassMappings().get(entityInstance.getClass());
        DocumentEntity entity = DocumentEntity.of((String)mapping.getName());
        mapping.getFields().stream().map(f -> this.to((FieldMapping)f, entityInstance)).filter(FieldValue::isNotEmpty).map(f -> f.toDocument(this, this.getConverters())).flatMap(Collection::stream).forEach(arg_0 -> ((DocumentEntity)entity).add(arg_0));
        return entity;
    }

    @Override
    public <T> T toEntity(Class<T> entityClass, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(entityClass, "entityClass is required");
        return this.toEntity(entityClass, entity.getDocuments());
    }

    @Override
    public <T> T toEntity(T entityInstance, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(entityInstance, "entityInstance is required");
        ClassMapping mapping = this.getClassMappings().get(entityInstance.getClass());
        return this.convertEntity(entity.getDocuments(), mapping, entityInstance);
    }

    protected <T> T toEntity(Class<T> entityClass, List<Document> documents) {
        ClassMapping mapping = this.getClassMappings().get(entityClass);
        Object instance = mapping.newInstance();
        return (T)this.convertEntity(documents, mapping, instance);
    }

    @Override
    public <T> T toEntity(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        ClassMapping mapping = this.getClassMappings().findByName(entity.getName());
        Object instance = mapping.newInstance();
        return (T)this.convertEntity(entity.getDocuments(), mapping, instance);
    }

    private <T> T convertEntity(List<Document> documents, ClassMapping mapping, T instance) {
        Map fieldsGroupByName = mapping.getFieldsGroupByName();
        List names = documents.stream().map(Document::getName).sorted().collect(Collectors.toList());
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        Predicate<String> isElementType = k -> {
            FieldType type = ((FieldMapping)fieldsGroupByName.get(k)).getType();
            return FieldType.EMBEDDED.equals((Object)type) || FieldType.SUBENTITY.equals((Object)type);
        };
        fieldsGroupByName.keySet().stream().filter(existField.or(isElementType)).forEach(this.feedObject(instance, documents, fieldsGroupByName));
        return instance;
    }

    protected <T> Consumer<String> feedObject(T instance, List<Document> documents, Map<String, FieldMapping> fieldsGroupByName) {
        return k -> {
            Optional<Document> document = documents.stream().filter(c -> c.getName().equals(k)).findFirst();
            FieldMapping field = (FieldMapping)fieldsGroupByName.get(k);
            DocumentFieldConverter fieldConverter = this.converterFactory.get(field);
            fieldConverter.convert(instance, documents, document, field, this);
        };
    }

    private DocumentFieldValue to(FieldMapping field, Object entityInstance) {
        Object value = field.read(entityInstance);
        return DefaultDocumentFieldValue.of(value, field);
    }
}

