/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.IdNotFoundException;
import org.jnosql.artemis.Page;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentEventPersistManager;
import org.jnosql.artemis.document.DocumentMapperObserver;
import org.jnosql.artemis.document.DocumentPage;
import org.jnosql.artemis.document.DocumentPreparedStatement;
import org.jnosql.artemis.document.DocumentQueryPagination;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.DocumentWorkflow;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.artemis.util.ConverterUtil;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.DocumentQueryParser;
import org.jnosql.diana.api.document.query.DocumentQueryBuilder;

public abstract class AbstractDocumentTemplate
implements DocumentTemplate {
    private static final DocumentQueryParser PARSER = DocumentQueryParser.getParser();
    private final UnaryOperator<DocumentEntity> insert = e -> this.getManager().insert(e);
    private final UnaryOperator<DocumentEntity> update = e -> this.getManager().update(e);
    private DocumentObserverParser columnQueryParser;

    protected abstract DocumentEntityConverter getConverter();

    protected abstract DocumentCollectionManager getManager();

    protected abstract DocumentWorkflow getWorkflow();

    protected abstract DocumentEventPersistManager getPersistManager();

    protected abstract ClassMappings getClassMappings();

    protected abstract Converters getConverters();

    private DocumentObserverParser getObserver() {
        if (Objects.isNull(this.columnQueryParser)) {
            this.columnQueryParser = new DocumentMapperObserver(this.getClassMappings());
        }
        return this.columnQueryParser;
    }

    @Override
    public <T> T insert(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.getWorkflow().flow(entity, this.insert);
    }

    @Override
    public <T> T insert(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return this.getWorkflow().flow(entity, e -> this.getManager().insert(e, ttl));
    }

    @Override
    public <T> T update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.getWorkflow().flow(entity, this.update);
    }

    @Override
    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getPersistManager().firePreDeleteQuery(query);
        this.getManager().delete(query);
    }

    @Override
    public <T> List<T> select(DocumentQuery query) {
        return this.executeQuery(query);
    }

    @Override
    public <T> Page<T> select(DocumentQueryPagination query) {
        List<T> entities = this.executeQuery(query);
        return new DocumentPage<T>(this, entities, query);
    }

    @Override
    public <T, K> Optional<T> find(Class<T> entityClass, K id) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(id, "id is required");
        ClassMapping classMapping = this.getClassMappings().get(entityClass);
        FieldMapping idField = (FieldMapping)classMapping.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)entityClass));
        Object value = ConverterUtil.getValue(id, (ClassMapping)classMapping, (String)idField.getFieldName(), (Converters)this.getConverters());
        DocumentQuery query = DocumentQueryBuilder.select().from(classMapping.getName()).where(idField.getName()).eq(value).build();
        return this.singleResult(query);
    }

    @Override
    public <T, K> void delete(Class<T> entityClass, K id) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(id, "id is required");
        ClassMapping classMapping = this.getClassMappings().get(entityClass);
        FieldMapping idField = (FieldMapping)classMapping.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)entityClass));
        Object value = ConverterUtil.getValue(id, (ClassMapping)classMapping, (String)idField.getFieldName(), (Converters)this.getConverters());
        DocumentDeleteQuery query = DocumentQueryBuilder.delete().from(classMapping.getName()).where(idField.getName()).eq(value).build();
        this.delete(query);
    }

    @Override
    public <T> List<T> query(String query) {
        Objects.requireNonNull(query, "query is required");
        return PARSER.query(query, this.getManager(), this.getObserver()).stream().map(c -> this.getConverter().toEntity((DocumentEntity)c)).collect(Collectors.toList());
    }

    @Override
    public <T> Optional<T> singleResult(String query) {
        List<T> entities = this.query(query);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.ofNullable(entities.get(0));
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    @Override
    public PreparedStatement prepare(String query) {
        return new DocumentPreparedStatement(PARSER.prepare(query, this.getManager(), this.getObserver()), this.getConverter());
    }

    @Override
    public long count(String documentCollection) {
        return this.getManager().count(documentCollection);
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        ClassMapping classMapping = this.getClassMappings().get(entityClass);
        return this.getManager().count(classMapping.getName());
    }

    private <T> List<T> executeQuery(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getPersistManager().firePreQuery(query);
        List entities = this.getManager().select(query);
        Function<DocumentEntity, Object> function = e -> this.getConverter().toEntity((DocumentEntity)e);
        return entities.stream().map(function).collect(Collectors.toList());
    }
}

