/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jnosql.artemis.AttributeConverter;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.DocumentEntityConverter;
import org.jnosql.artemis.document.DocumentFieldValue;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.artemis.reflection.FieldType;
import org.jnosql.artemis.reflection.FieldValue;
import org.jnosql.artemis.reflection.GenericFieldMapping;
import org.jnosql.diana.api.document.Document;

final class DefaultDocumentFieldValue
implements DocumentFieldValue {
    private final FieldValue fieldValue;

    private DefaultDocumentFieldValue(FieldValue fieldValue) {
        this.fieldValue = fieldValue;
    }

    public Object getValue() {
        return this.fieldValue.getValue();
    }

    public FieldMapping getField() {
        return this.fieldValue.getField();
    }

    @Override
    public List<Document> toDocument(DocumentEntityConverter converter, Converters converters) {
        if (FieldType.EMBEDDED.equals((Object)this.getType())) {
            return converter.toDocument(this.getValue()).getDocuments();
        }
        if (FieldType.SUBENTITY.equals((Object)this.getType())) {
            return Collections.singletonList(Document.of((String)this.getName(), (Object)converter.toDocument(this.getValue()).getDocuments()));
        }
        if (this.isEmbeddableCollection()) {
            return Collections.singletonList(Document.of((String)this.getName(), this.getDocuments(converter)));
        }
        Optional optionalConverter = this.getField().getConverter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((Class)optionalConverter.get());
            return Collections.singletonList(Document.of((String)this.getName(), (Object)attributeConverter.convertToDatabaseColumn(this.getValue())));
        }
        return Collections.singletonList(Document.of((String)this.getName(), (Object)this.getValue()));
    }

    private List<List<Document>> getDocuments(DocumentEntityConverter converter) {
        ArrayList<List<Document>> documents = new ArrayList<List<Document>>();
        for (Object element : (Iterable)this.getValue()) {
            documents.add(converter.toDocument(element).getDocuments());
        }
        return documents;
    }

    private boolean isEmbeddableCollection() {
        return FieldType.COLLECTION.equals((Object)this.getType()) && this.isEmbeddableElement();
    }

    public boolean isNotEmpty() {
        return this.fieldValue.isNotEmpty();
    }

    private FieldType getType() {
        return this.getField().getType();
    }

    private boolean isEmbeddableElement() {
        return ((GenericFieldMapping)this.getField()).isEmbeddable();
    }

    private String getName() {
        return this.getField().getName();
    }

    static DocumentFieldValue of(Object value, FieldMapping field) {
        return new DefaultDocumentFieldValue(FieldValue.of((Object)value, (FieldMapping)field));
    }

    public String toString() {
        return "DocumentFieldValue{fieldValue=" + this.fieldValue + '}';
    }
}

