/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.jnosql.artemis.AttributeConverter;
import org.jnosql.artemis.document.AbstractDocumentEntityConverter;
import org.jnosql.artemis.document.DocumentFieldConverter;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.artemis.reflection.FieldType;
import org.jnosql.artemis.reflection.GenericFieldMapping;
import org.jnosql.diana.api.TypeReference;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.Document;

class DocumentFieldConverters {
    DocumentFieldConverters() {
    }

    private static class CollectionEmbeddableConverter
    implements DocumentFieldConverter {
        private CollectionEmbeddableConverter() {
        }

        @Override
        public <T> void convert(T instance, List<Document> documents, Optional<Document> document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            document.ifPresent(this.convertDocument(instance, field, converter));
        }

        private <T> Consumer<Document> convertDocument(T instance, FieldMapping field, AbstractDocumentEntityConverter converter) {
            return document -> {
                GenericFieldMapping genericField = (GenericFieldMapping)field;
                Collection collection = genericField.getCollectionInstance();
                List embeddable = (List)document.get();
                for (List documentList : embeddable) {
                    Object element = converter.toEntity(genericField.getElementType(), documentList);
                    collection.add(element);
                }
                field.write(instance, (Object)collection);
            };
        }
    }

    private static class DefaultConverter
    implements DocumentFieldConverter {
        private DefaultConverter() {
        }

        @Override
        public <T> void convert(T instance, List<Document> documents, Optional<Document> document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            Value value = document.get().getValue();
            Optional optionalConverter = field.getConverter();
            if (optionalConverter.isPresent()) {
                AttributeConverter attributeConverter = converter.getConverters().get((Class)optionalConverter.get());
                Object attributeConverted = attributeConverter.convertToEntityAttribute(value.get());
                field.write(instance, field.getValue(Value.of((Object)attributeConverted)));
            } else {
                field.write(instance, field.getValue(value));
            }
        }
    }

    private static class EmbeddedFieldConverter
    implements DocumentFieldConverter {
        private EmbeddedFieldConverter() {
        }

        @Override
        public <T> void convert(T instance, List<Document> documents, Optional<Document> document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            Field nativeField = field.getNativeField();
            Object subEntity = converter.toEntity(nativeField.getType(), documents);
            field.write(instance, subEntity);
        }
    }

    private static class SubEntityConverter
    implements DocumentFieldConverter {
        private SubEntityConverter() {
        }

        @Override
        public <T> void convert(T instance, List<Document> documents, Optional<Document> document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            if (document.isPresent()) {
                Document sudDocument = document.get();
                Object value = sudDocument.get();
                if (value instanceof Map) {
                    Map map = (Map)value;
                    ArrayList<Document> embeddedDocument = new ArrayList<Document>();
                    for (Map.Entry entry : map.entrySet()) {
                        embeddedDocument.add(Document.of((String)entry.getKey().toString(), entry.getValue()));
                    }
                    field.write(instance, converter.toEntity(field.getNativeField().getType(), embeddedDocument));
                } else {
                    field.write(instance, converter.toEntity(field.getNativeField().getType(), (List)sudDocument.get((TypeSupplier)new TypeReference<List<Document>>(){})));
                }
            } else {
                field.write(instance, converter.toEntity(field.getNativeField().getType(), documents));
            }
        }
    }

    static class DocumentFieldConverterFactory {
        private final EmbeddedFieldConverter embeddedFieldConverter = new EmbeddedFieldConverter();
        private final DefaultConverter defaultConverter = new DefaultConverter();
        private final CollectionEmbeddableConverter embeddableConverter = new CollectionEmbeddableConverter();
        private final SubEntityConverter subEntityConverter = new SubEntityConverter();

        DocumentFieldConverterFactory() {
        }

        DocumentFieldConverter get(FieldMapping field) {
            if (FieldType.EMBEDDED.equals((Object)field.getType())) {
                return this.embeddedFieldConverter;
            }
            if (FieldType.SUBENTITY.equals((Object)field.getType())) {
                return this.subEntityConverter;
            }
            if (this.isCollectionEmbeddable(field)) {
                return this.embeddableConverter;
            }
            return this.defaultConverter;
        }

        private boolean isCollectionEmbeddable(FieldMapping field) {
            return FieldType.COLLECTION.equals((Object)field.getType()) && ((GenericFieldMapping)field).isEmbeddable();
        }
    }
}

