/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Optional;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.diana.api.document.DocumentObserverParser;

final class DocumentMapperObserver
implements DocumentObserverParser {
    private final ClassMappings mappings;

    DocumentMapperObserver(ClassMappings mappings) {
        this.mappings = mappings;
    }

    public String fireEntity(String entity) {
        Optional<ClassMapping> mapping = this.getClassMapping(entity);
        return mapping.map(ClassMapping::getName).orElse(entity);
    }

    public String fireField(String entity, String field) {
        Optional<ClassMapping> mapping = this.getClassMapping(entity);
        return mapping.map(c -> c.getColumnField(field)).orElse(field);
    }

    private Optional<ClassMapping> getClassMapping(String entity) {
        Optional bySimpleName = this.mappings.findBySimpleName(entity);
        if (bySimpleName.isPresent()) {
            return bySimpleName;
        }
        return this.mappings.findByClassName(entity);
    }
}

