/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jnosql.artemis.Page;
import org.jnosql.artemis.Pagination;
import org.jnosql.artemis.document.DocumentQueryPagination;
import org.jnosql.artemis.document.DocumentTemplate;

final class DocumentPage<T>
implements Page<T> {
    private final DocumentTemplate template;
    private final List<T> entities;
    private final DocumentQueryPagination query;

    DocumentPage(DocumentTemplate template, List<T> entities, DocumentQueryPagination query) {
        this.template = template;
        this.entities = entities;
        this.query = query;
    }

    public Pagination getPagination() {
        return this.query.getPagination();
    }

    public Page<T> next() {
        return this.template.select(this.query.next());
    }

    public List<T> getContent() {
        return this.entities;
    }

    public <C extends Collection<T>> C getContent(Supplier<C> collectionFactory) {
        Objects.requireNonNull(collectionFactory, "collectionFactory is required");
        return (C)((Collection)this.get().collect(Collectors.toCollection(collectionFactory)));
    }

    public Stream<T> get() {
        return this.entities.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPage that = (DocumentPage)o;
        return Objects.equals(this.entities, that.entities) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.entities, this.query);
    }

    public String toString() {
        return "DocumentPage{entities=" + this.entities + ", query=" + this.query + '}';
    }
}

