/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.artemis.Page;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.document.DocumentQueryPagination;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;

public interface DocumentTemplate {
    public <T> T insert(T var1);

    public <T> T insert(T var1, Duration var2);

    default public <T> Iterable<T> insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    default public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(d -> this.insert(d, ttl)).collect(Collectors.toList());
    }

    public <T> T update(T var1);

    default public <T> Iterable<T> update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    public void delete(DocumentDeleteQuery var1);

    public <T> List<T> select(DocumentQuery var1);

    public <T> Page<T> select(DocumentQueryPagination var1);

    public <T> List<T> query(String var1);

    public <T> Optional<T> singleResult(String var1);

    public PreparedStatement prepare(String var1);

    public <T, K> Optional<T> find(Class<T> var1, K var2);

    public <T, K> void delete(Class<T> var1, K var2);

    public long count(String var1);

    public <T> long count(Class<T> var1);

    default public <T> Optional<T> singleResult(DocumentQuery query) {
        List<T> entities = this.select(query);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.of(entities.get(0));
        }
        throw new NonUniqueResultException("The query returns more than one entity, query: " + query);
    }
}

