/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.jnosql.artemis.DynamicQueryException;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.BaseDocumentRepository;
import org.jnosql.artemis.query.RepositoryType;
import org.jnosql.artemis.reflection.DynamicAsyncQueryMethodReturn;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;

public abstract class AbstractDocumentRepositoryAsyncProxy<T>
extends BaseDocumentRepository
implements InvocationHandler {
    protected abstract RepositoryAsync getRepository();

    protected abstract DocumentTemplateAsync getTemplate();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                DocumentQuery query = this.getQuery(method, args);
                return this.executeQuery(this.getCallBack(args), query);
            }
            case DELETE_BY: {
                DocumentDeleteQuery deleteQuery = this.getDeleteQuery(method, args);
                return this.executeDelete(args, deleteQuery);
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                DynamicAsyncQueryMethodReturn nativeQuery = DynamicAsyncQueryMethodReturn.builder().withArgs(args).withMethod(method).withAsyncConsumer(this.getTemplate()::query).withPrepareConverter(q -> this.getTemplate().prepare((String)q)).build();
                nativeQuery.execute();
                return Void.class;
            }
        }
        return Void.class;
    }

    private Object executeDelete(Object[] args, DocumentDeleteQuery query1) {
        Object callBack = this.getCallBack(args);
        if (callBack instanceof Consumer) {
            this.getTemplate().delete(query1, (Consumer)callBack);
        } else {
            this.getTemplate().delete(query1);
        }
        return Void.class;
    }

    private Object getCallBack(Object[] args) {
        return args[args.length - 1];
    }

    private Object executeQuery(Object arg, DocumentQuery query) {
        if (!(arg instanceof Consumer)) {
            throw new DynamicQueryException("On select async method you must put a java.util.function.Consumer as end parameter as callback");
        }
        this.getTemplate().select(query, (Consumer)arg);
        return Void.class;
    }
}

