/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jnosql.artemis.Page;
import org.jnosql.artemis.Pagination;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.document.DocumentQueryPagination;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.query.BaseDocumentRepository;
import org.jnosql.artemis.query.RepositoryType;
import org.jnosql.artemis.reflection.DynamicQueryMethodReturn;
import org.jnosql.artemis.reflection.DynamicReturn;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.DocumentQueryBuilder;

public abstract class AbstractDocumentRepositoryProxy<T>
extends BaseDocumentRepository
implements InvocationHandler {
    protected abstract Repository getRepository();

    protected abstract DocumentTemplate getTemplate();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        Class typeClass = this.getClassMapping().getClassInstance();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                DocumentQuery query = this.getQuery(method, args);
                return this.executeQuery(method, args, typeClass, query);
            }
            case FIND_ALL: {
                DocumentQuery queryFindAll = DocumentQueryBuilder.select().from(this.getClassMapping().getName()).build();
                return this.executeQuery(method, args, typeClass, this.getQuerySorts(args, queryFindAll));
            }
            case DELETE_BY: {
                DocumentDeleteQuery documentDeleteQuery = this.getDeleteQuery(method, args);
                this.getTemplate().delete(documentDeleteQuery);
                return null;
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(args).withMethod(method).withTypeClass(typeClass).withPrepareConverter(q -> this.getTemplate().prepare((String)q)).withQueryConverter(q -> this.getTemplate().query((String)q)).build();
                return methodReturn.execute();
            }
        }
        return Void.class;
    }

    private Object executeQuery(Method method, Object[] args, Class<?> typeClass, DocumentQuery query) {
        DynamicReturn dynamicReturn = DynamicReturn.builder().withClassSource(typeClass).withMethodSource(method).withList(() -> this.getTemplate().select(query)).withSingleResult(() -> this.getTemplate().singleResult(query)).withPagination(DynamicReturn.findPagination((Object[])args)).withListPagination(this.listPagination(query)).withSingleResultPagination(this.getSingleResult(query)).withPage(this.getPage(query)).build();
        return dynamicReturn.execute();
    }

    private Function<Pagination, Page<T>> getPage(DocumentQuery query) {
        return p -> this.getTemplate().select(DocumentQueryPagination.of(query, p));
    }

    private Function<Pagination, Optional<T>> getSingleResult(DocumentQuery query) {
        return p -> {
            DocumentQueryPagination queryPagination = DocumentQueryPagination.of(query, p);
            return this.getTemplate().singleResult(queryPagination);
        };
    }

    private Function<Pagination, List<T>> listPagination(DocumentQuery query) {
        return p -> {
            DocumentQueryPagination queryPagination = DocumentQueryPagination.of(query, p);
            return this.getTemplate().select((DocumentQuery)queryPagination);
        };
    }
}

