/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jnosql.aphrodite.antlr.method.DeleteMethodFactory;
import org.jnosql.aphrodite.antlr.method.SelectMethodFactory;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.query.ArtemisDocumentQuery;
import org.jnosql.artemis.document.query.RepositoryDocumentObserverParser;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.DynamicReturn;
import org.jnosql.artemis.util.ParamsBinder;
import org.jnosql.diana.api.Params;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.DeleteQueryConverter;
import org.jnosql.diana.api.document.query.DocumentDeleteQueryParams;
import org.jnosql.diana.api.document.query.DocumentQueryParams;
import org.jnosql.diana.api.document.query.SelectQueryConverter;
import org.jnosql.query.DeleteQuery;
import org.jnosql.query.SelectQuery;

abstract class BaseDocumentRepository {
    private DocumentObserverParser parser;
    private ParamsBinder paramsBinder;

    BaseDocumentRepository() {
    }

    protected abstract Converters getConverters();

    protected abstract ClassMapping getClassMapping();

    protected DocumentQuery getQuery(Method method, Object[] args) {
        SelectMethodFactory selectMethodFactory = SelectMethodFactory.get();
        SelectQuery selectQuery = (SelectQuery)selectMethodFactory.apply((Object)method, (Object)this.getClassMapping().getName());
        SelectQueryConverter converter = SelectQueryConverter.get();
        DocumentQueryParams queryParams = (DocumentQueryParams)converter.apply((Object)selectQuery, (Object)this.getParser());
        DocumentQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        this.getParamsBinder().bind(params, args, method);
        return this.getQuerySorts(args, query);
    }

    protected DocumentQuery getQuerySorts(Object[] args, DocumentQuery query) {
        List sorts = DynamicReturn.findSorts((Object[])args);
        if (!sorts.isEmpty()) {
            ArrayList<Sort> newOrders = new ArrayList<Sort>();
            newOrders.addAll(query.getSorts());
            newOrders.addAll(sorts);
            return new ArtemisDocumentQuery(newOrders, query.getLimit(), query.getSkip(), query.getCondition().orElse(null), query.getDocumentCollection());
        }
        return query;
    }

    protected DocumentDeleteQuery getDeleteQuery(Method method, Object[] args) {
        DeleteMethodFactory deleteMethodFactory = DeleteMethodFactory.get();
        DeleteQuery deleteQuery = (DeleteQuery)deleteMethodFactory.apply((Object)method, (Object)this.getClassMapping().getName());
        DeleteQueryConverter converter = DeleteQueryConverter.get();
        DocumentDeleteQueryParams queryParams = (DocumentDeleteQueryParams)converter.apply((Object)deleteQuery, (Object)this.getParser());
        DocumentDeleteQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        this.getParamsBinder().bind(params, args, method);
        return query;
    }

    protected DocumentObserverParser getParser() {
        if (this.parser == null) {
            this.parser = new RepositoryDocumentObserverParser(this.getClassMapping());
        }
        return this.parser;
    }

    protected ParamsBinder getParamsBinder() {
        if (Objects.isNull(this.paramsBinder)) {
            this.paramsBinder = new ParamsBinder(this.getClassMapping(), this.getConverters());
        }
        return this.paramsBinder;
    }
}

