/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.document.DocumentRepositoryProducer;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.DocumentTemplateProducer;
import org.jnosql.artemis.document.query.DocumentRepositoryProxy;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.diana.api.document.DocumentCollectionManager;

@ApplicationScoped
class DefaultDocumentRepositoryProducer
implements DocumentRepositoryProducer {
    @Inject
    private ClassMappings classMappings;
    @Inject
    private Converters converters;
    @Inject
    private DocumentTemplateProducer producer;

    DefaultDocumentRepositoryProducer() {
    }

    @Override
    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, DocumentCollectionManager manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        Object template = this.producer.get(manager);
        return this.get(repositoryClass, (DocumentTemplate)template);
    }

    @Override
    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, DocumentTemplate template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        DocumentRepositoryProxy handler = new DocumentRepositoryProxy(template, this.classMappings, repositoryClass, this.converters);
        return (R)((Repository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

