/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.ParameterizedType;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.query.AbstractDocumentRepository;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryProxy;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;

class DocumentRepositoryProxy<T>
extends AbstractDocumentRepositoryProxy<T> {
    private final DocumentTemplate template;
    private final DocumentRepository repository;
    private final ClassMapping classMapping;
    private final Converters converters;

    DocumentRepositoryProxy(DocumentTemplate template, ClassMappings classMappings, Class<?> repositoryType, Converters converters) {
        this.template = template;
        Class typeClass = (Class)((ParameterizedType)repositoryType.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.classMapping = classMappings.get(typeClass);
        this.repository = new DocumentRepository(template, this.classMapping);
        this.converters = converters;
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected DocumentTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected ClassMapping getClassMapping() {
        return this.classMapping;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    class DocumentRepository
    extends AbstractDocumentRepository
    implements Repository {
        private final DocumentTemplate template;
        private final ClassMapping classMapping;

        DocumentRepository(DocumentTemplate template, ClassMapping classMapping) {
            this.template = template;
            this.classMapping = classMapping;
        }

        @Override
        protected DocumentTemplate getTemplate() {
            return this.template;
        }

        @Override
        protected ClassMapping getClassMapping() {
            return this.classMapping;
        }
    }
}

