/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.DatabaseQualifier;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.DocumentRepositoryAsyncProxy;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.artemis.spi.AbstractBean;
import org.jnosql.artemis.util.AnnotationLiteralUtil;

public class RepositoryAsyncDocumentBean
extends AbstractBean<RepositoryAsync> {
    private final Class type;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public RepositoryAsyncDocumentBean(Class type, BeanManager beanManager, String provider) {
        super(beanManager);
        this.type = type;
        this.types = Collections.singleton(type);
        this.provider = provider;
        if (provider.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)DatabaseQualifier.ofDocument());
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
        } else {
            this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
        }
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public RepositoryAsync create(CreationalContext<RepositoryAsync> creationalContext) {
        ClassMappings classMappings = (ClassMappings)this.getInstance(ClassMappings.class);
        DocumentTemplateAsync repository = this.provider.isEmpty() ? (DocumentTemplateAsync)this.getInstance(DocumentTemplateAsync.class) : (DocumentTemplateAsync)this.getInstance(DocumentTemplateAsync.class, (Annotation)DatabaseQualifier.ofDocument((String)this.provider));
        Converters converters = (Converters)this.getInstance(Converters.class);
        DocumentRepositoryAsyncProxy handler = new DocumentRepositoryAsyncProxy(repository, classMappings, this.type, converters);
        return (RepositoryAsync)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "Async@" + DatabaseType.DOCUMENT + "-" + this.provider;
    }
}

