/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.DatabaseMetadata;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.Databases;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.query.RepositoryAsyncDocumentBean;
import org.jnosql.artemis.document.query.RepositoryDocumentBean;
import org.jnosql.artemis.document.spi.RepositoryAsyncUnitDocumentBean;
import org.jnosql.artemis.document.spi.RepositoryUnitDocumentBean;
import org.jnosql.artemis.document.spi.TemplateAsyncBean;
import org.jnosql.artemis.document.spi.TemplateBean;
import org.jnosql.artemis.util.ConfigurationUnitUtils;
import org.jnosql.artemis.util.RepositoryUnit;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;

public class DocumentCollectionProducerExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(DocumentCollectionProducerExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();
    private final Set<DatabaseMetadata> databasesAsync = new HashSet<DatabaseMetadata>();
    private final Collection<Class<?>> crudTypes = new HashSet();
    private final Collection<Class<?>> crudAsyncTypes = new HashSet();
    private final Collection<RepositoryUnit> repositoryUnits = new HashSet<RepositoryUnit>();
    private final Collection<RepositoryUnit> repositoryAsyncUnits = new HashSet<RepositoryUnit>();

    <T extends Repository> void observes(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (Repository.class.equals((Object)javaClass)) {
            return;
        }
        if (Arrays.asList(javaClass.getInterfaces()).contains(Repository.class) && Modifier.isInterface(javaClass.getModifiers())) {
            LOGGER.info("Adding a new Repository as discovered on document: " + javaClass);
            this.crudTypes.add(javaClass);
        }
    }

    <T extends RepositoryAsync> void observesAsync(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (RepositoryAsync.class.equals((Object)javaClass)) {
            return;
        }
        if (Arrays.asList(javaClass.getInterfaces()).contains(RepositoryAsync.class) && Modifier.isInterface(javaClass.getModifiers())) {
            LOGGER.info("Adding a new RepositoryAsync as discovered on document: " + javaClass);
            this.crudAsyncTypes.add(javaClass);
        }
    }

    <T, X extends DocumentCollectionManager> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.DOCUMENT, this.databases);
    }

    <T, X extends DocumentCollectionManagerAsync> void observesAsync(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.DOCUMENT, this.databasesAsync);
    }

    <T, R extends Repository<?, ?>> void observes(@Observes ProcessInjectionPoint<T, R> event) {
        this.observes(event.getInjectionPoint(), this.repositoryUnits);
    }

    <T, R extends RepositoryAsync<?, ?>> void observesAsync(@Observes ProcessInjectionPoint<T, R> event) {
        this.observes(event.getInjectionPoint(), this.repositoryAsyncUnits);
    }

    private void observes(InjectionPoint injectionPoint, Collection<RepositoryUnit> repositoryAsyncUnits) {
        if (ConfigurationUnitUtils.hasConfigurationUnit((InjectionPoint)injectionPoint)) {
            ConfigurationUnit configurationUnit = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint);
            Type type = injectionPoint.getType();
            RepositoryUnit unitRepository = RepositoryUnit.of((Class)((Class)type), (ConfigurationUnit)configurationUnit);
            if (unitRepository.isDocument()) {
                LOGGER.info(String.format("Found Repository to configuration unit document to configuration name %s fileName %s database: %s repository: %s", configurationUnit.name(), configurationUnit.fileName(), configurationUnit.database(), type.toString()));
                repositoryAsyncUnits.add(unitRepository);
            }
        }
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        LOGGER.info(String.format("Starting to process on documents: %d databases crud %d and crudAsync %d", this.databases.size(), this.crudTypes.size(), this.crudAsyncTypes.size()));
        this.databases.forEach(type -> {
            TemplateBean bean = new TemplateBean(beanManager, type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.databasesAsync.forEach(type -> {
            TemplateAsyncBean bean = new TemplateAsyncBean(beanManager, type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean((Bean)new RepositoryDocumentBean((Class)type, beanManager, ""));
            }
            this.databases.forEach(database -> {
                RepositoryDocumentBean bean = new RepositoryDocumentBean((Class)type, beanManager, database.getProvider());
                afterBeanDiscovery.addBean((Bean)bean);
            });
        });
        this.crudAsyncTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean((Bean)new RepositoryAsyncDocumentBean((Class)type, beanManager, ""));
            }
            this.databasesAsync.forEach(database -> {
                RepositoryAsyncDocumentBean bean = new RepositoryAsyncDocumentBean((Class)type, beanManager, database.getProvider());
                afterBeanDiscovery.addBean((Bean)bean);
            });
        });
        this.repositoryUnits.forEach(type -> afterBeanDiscovery.addBean((Bean)new RepositoryUnitDocumentBean(beanManager, (RepositoryUnit)type)));
        this.repositoryAsyncUnits.forEach(type -> afterBeanDiscovery.addBean((Bean)new RepositoryAsyncUnitDocumentBean(beanManager, (RepositoryUnit)type)));
    }
}

