/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jnosql.artemis.ConfigurationReader;
import org.jnosql.artemis.ConfigurationSettingsUnit;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.artemis.util.ConfigurationUnitUtils;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsyncFactory;
import org.jnosql.diana.api.document.DocumentCollectionManagerFactory;
import org.jnosql.diana.api.document.DocumentConfiguration;
import org.jnosql.diana.api.document.DocumentConfigurationAsync;

@ApplicationScoped
class DocumentConfigurationProducer {
    @Inject
    private Reflections reflections;
    @Inject
    private Instance<ConfigurationReader> configurationReader;

    DocumentConfigurationProducer() {
    }

    @ConfigurationUnit
    @Produces
    public <T extends DocumentCollectionManager> DocumentCollectionManagerFactory<T> getGenerics(InjectionPoint injectionPoint) {
        return this.getDocumentCollection(injectionPoint);
    }

    @ConfigurationUnit
    @Produces
    public DocumentCollectionManagerFactory get(InjectionPoint injectionPoint) {
        return this.getDocumentCollection(injectionPoint);
    }

    @ConfigurationUnit
    @Produces
    public <T extends DocumentCollectionManagerAsync> DocumentCollectionManagerAsyncFactory<T> getAsyncGenerics(InjectionPoint injectionPoint) {
        return this.getDocumentCollectionAsync(injectionPoint);
    }

    @ConfigurationUnit
    @Produces
    public DocumentCollectionManagerAsyncFactory getAsync(InjectionPoint injectionPoint) {
        return this.getDocumentCollectionAsync(injectionPoint);
    }

    private <T extends DocumentCollectionManagerAsync> DocumentCollectionManagerAsyncFactory<T> getDocumentCollectionAsync(InjectionPoint injectionPoint) {
        ConfigurationUnit annotation = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint);
        return this.getFactoryAsync(annotation);
    }

    <T extends DocumentCollectionManagerAsync> DocumentCollectionManagerAsyncFactory<T> getFactoryAsync(ConfigurationUnit annotation) {
        ConfigurationSettingsUnit unit = ((ConfigurationReader)this.configurationReader.get()).read(annotation, DocumentConfigurationAsync.class);
        Class configurationClass = (Class)unit.getProvider().orElseThrow(() -> new IllegalStateException("The DocumentConfiguration provider is required in the configuration"));
        DocumentConfigurationAsync documentConfiguration = (DocumentConfigurationAsync)this.reflections.newInstance(configurationClass);
        return documentConfiguration.getAsync(unit.getSettings());
    }

    <T extends DocumentCollectionManager> DocumentCollectionManagerFactory<T> getFactory(ConfigurationUnit annotation) {
        ConfigurationSettingsUnit unit = ((ConfigurationReader)this.configurationReader.get()).read(annotation, DocumentConfiguration.class);
        Class configurationClass = (Class)unit.getProvider().orElseThrow(() -> new IllegalStateException("The DocumentConfiguration provider is required in the configuration"));
        DocumentConfiguration configuration = (DocumentConfiguration)this.reflections.newInstance(configurationClass);
        return configuration.get(unit.getSettings());
    }

    private <T extends DocumentCollectionManager> DocumentCollectionManagerFactory<T> getDocumentCollection(InjectionPoint injectionPoint) {
        ConfigurationUnit annotation = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint);
        return this.getFactory(annotation);
    }
}

