/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentRepositoryAsyncProducer;
import org.jnosql.artemis.document.spi.DocumentConfigurationProducer;
import org.jnosql.artemis.spi.AbstractBean;
import org.jnosql.artemis.util.RepositoryUnit;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsyncFactory;

class RepositoryAsyncUnitDocumentBean
extends AbstractBean<RepositoryAsync<?, ?>> {
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;
    private final RepositoryUnit repositoryUnit;

    RepositoryAsyncUnitDocumentBean(BeanManager beanManager, RepositoryUnit repositoryUnit) {
        super(beanManager);
        this.types = Collections.singleton(repositoryUnit.getRepository());
        this.qualifiers = Collections.singleton(repositoryUnit.getUnit());
        this.repositoryUnit = repositoryUnit;
    }

    public Class<?> getBeanClass() {
        return this.repositoryUnit.getRepository();
    }

    public RepositoryAsync<?, ?> create(CreationalContext<RepositoryAsync<?, ?>> context) {
        return this.get();
    }

    private <T, K, R extends RepositoryAsync<T, K>> R get() {
        DocumentRepositoryAsyncProducer producer = (DocumentRepositoryAsyncProducer)this.getInstance(DocumentRepositoryAsyncProducer.class);
        DocumentConfigurationProducer configurationProducer = (DocumentConfigurationProducer)this.getInstance(DocumentConfigurationProducer.class);
        Class repository = this.repositoryUnit.getRepository();
        DocumentCollectionManagerAsyncFactory managerFactory = configurationProducer.getFactoryAsync(this.repositoryUnit.getUnit());
        DocumentCollectionManagerAsync manager = managerFactory.getAsync(this.repositoryUnit.getDatabase());
        return producer.get(repository, manager);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return "document-async: " + this.repositoryUnit.toString();
    }
}

