/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.document.DocumentRepositoryProducer;
import org.jnosql.artemis.document.spi.DocumentConfigurationProducer;
import org.jnosql.artemis.spi.AbstractBean;
import org.jnosql.artemis.util.RepositoryUnit;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerFactory;

class RepositoryUnitDocumentBean
extends AbstractBean<Repository<?, ?>> {
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;
    private final RepositoryUnit repositoryUnit;

    RepositoryUnitDocumentBean(BeanManager beanManager, RepositoryUnit repositoryUnit) {
        super(beanManager);
        this.types = Collections.singleton(repositoryUnit.getRepository());
        this.qualifiers = Collections.singleton(repositoryUnit.getUnit());
        this.repositoryUnit = repositoryUnit;
    }

    public Class<?> getBeanClass() {
        return this.repositoryUnit.getRepository();
    }

    public Repository<?, ?> create(CreationalContext<Repository<?, ?>> context) {
        return this.get();
    }

    private <T, K, R extends Repository<T, K>> R get() {
        DocumentRepositoryProducer producer = (DocumentRepositoryProducer)this.getInstance(DocumentRepositoryProducer.class);
        DocumentConfigurationProducer configurationProducer = (DocumentConfigurationProducer)this.getInstance(DocumentConfigurationProducer.class);
        Class repository = this.repositoryUnit.getRepository();
        DocumentCollectionManagerFactory managerFactory = configurationProducer.getFactory(this.repositoryUnit.getUnit());
        DocumentCollectionManager manager = managerFactory.get(this.repositoryUnit.getDatabase());
        return producer.get(repository, manager);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return "document: " + this.repositoryUnit.toString();
    }
}

