/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jnosql.artemis.DatabaseQualifier;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.DocumentTemplateAsyncProducer;
import org.jnosql.artemis.spi.AbstractBean;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;

class TemplateAsyncBean
extends AbstractBean<DocumentTemplateAsync> {
    private final Set<Type> types = Collections.singleton(DocumentTemplateAsync.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateAsyncBean(BeanManager beanManager, String provider) {
        super(beanManager);
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
    }

    public Class<?> getBeanClass() {
        return DocumentTemplateAsync.class;
    }

    public DocumentTemplateAsync create(CreationalContext<DocumentTemplateAsync> creationalContext) {
        DocumentTemplateAsyncProducer producer = (DocumentTemplateAsyncProducer)this.getInstance(DocumentTemplateAsyncProducer.class);
        DocumentCollectionManagerAsync manager = this.getManager();
        return producer.get(manager);
    }

    private DocumentCollectionManagerAsync getManager() {
        Bean bean = (Bean)this.getBeanManager().getBeans(DocumentCollectionManagerAsync.class, new Annotation[]{DatabaseQualifier.ofDocument((String)this.provider)}).iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)bean);
        return (DocumentCollectionManagerAsync)this.getBeanManager().getReference(bean, DocumentCollectionManagerAsync.class, ctx);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return DocumentTemplateAsync.class.getName() + DatabaseType.COLUMN + "-" + this.provider;
    }
}

