/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.AttributeConverter;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.EntityNotFoundException;
import org.jnosql.artemis.graph.DefaultProperty;
import org.jnosql.artemis.graph.EdgeEntity;
import org.jnosql.artemis.graph.FieldGraph;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.FieldRepresentation;
import org.jnosql.artemis.reflection.FieldType;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.diana.api.Value;

abstract class AbstractGraphConverter
implements GraphConverter {
    AbstractGraphConverter() {
    }

    protected abstract ClassRepresentations getClassRepresentations();

    protected abstract Reflections getReflections();

    protected abstract Converters getConverters();

    protected abstract Graph getGraph();

    @Override
    public <T> Vertex toVertex(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        ClassRepresentation representation = this.getClassRepresentations().get(entity.getClass());
        String label = representation.getName();
        List fields = representation.getFields().stream().map(f -> this.to((FieldRepresentation)f, entity)).filter(FieldGraph::isNotEmpty).collect(Collectors.toList());
        Optional<FieldGraph> id = fields.stream().filter(FieldGraph::isId).findFirst();
        Function<Property, Vertex> findVertexOrCreateWithId = p -> {
            Iterator vertices = this.getGraph().vertices(new Object[]{p.value()});
            return vertices.hasNext() ? (Vertex)vertices.next() : this.getGraph().addVertex(new Object[]{T.label, label, T.id, p.value()});
        };
        Vertex vertex = id.map(i -> i.toElement(this.getConverters())).map(findVertexOrCreateWithId).orElseGet(() -> this.getGraph().addVertex(label));
        fields.stream().filter(FieldGraph::isNotId).flatMap(f -> f.toElements(this, this.getConverters()).stream()).forEach(p -> vertex.property(p.key(), p.value()));
        return vertex;
    }

    @Override
    public <T> List<Property<?>> getProperties(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        ClassRepresentation representation = this.getClassRepresentations().get(entity.getClass());
        List fields = representation.getFields().stream().map(f -> this.to((FieldRepresentation)f, entity)).filter(FieldGraph::isNotEmpty).collect(Collectors.toList());
        return fields.stream().filter(FieldGraph::isNotId).flatMap(f -> f.toElements(this, this.getConverters()).stream()).collect(Collectors.toList());
    }

    @Override
    public <T> T toEntity(Vertex vertex) {
        Objects.requireNonNull(vertex, "vertex is required");
        ClassRepresentation representation = this.getClassRepresentations().findByName(vertex.label());
        List<Property> properties = vertex.keys().stream().map(k -> DefaultProperty.of(k, vertex.value(k))).collect(Collectors.toList());
        T entity = this.toEntity(representation.getClassInstance(), properties);
        this.feedId(vertex, entity);
        return entity;
    }

    @Override
    public <T> T toEntity(Class<T> entityClass, Vertex vertex) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(vertex, "vertex is required");
        List<Property> properties = vertex.keys().stream().map(k -> DefaultProperty.of(k, vertex.value(k))).collect(Collectors.toList());
        T entity = this.toEntity(entityClass, properties);
        this.feedId(vertex, entity);
        return entity;
    }

    @Override
    public <T> T toEntity(T entityInstance, Vertex vertex) {
        Objects.requireNonNull(entityInstance, "entityInstance is required");
        Objects.requireNonNull(vertex, "vertex is required");
        List<Property> properties = vertex.keys().stream().map(k -> DefaultProperty.of(k, vertex.value(k))).collect(Collectors.toList());
        ClassRepresentation representation = this.getClassRepresentations().get(entityInstance.getClass());
        this.convertEntity(properties, representation, entityInstance);
        this.feedId(vertex, entityInstance);
        return entityInstance;
    }

    @Override
    public EdgeEntity toEdgeEntity(Edge edge) {
        Objects.requireNonNull(edge, "vertex is required");
        Object out = this.toEntity(edge.outVertex());
        Object in = this.toEntity(edge.inVertex());
        return EdgeEntity.of(out, edge, in);
    }

    @Override
    public Edge toEdge(EdgeEntity edge) {
        Objects.requireNonNull(edge, "vertex is required");
        Object id = edge.getId().get();
        Iterator edges = this.getGraph().edges(new Object[]{id});
        if (edges.hasNext()) {
            return (Edge)edges.next();
        }
        throw new EntityNotFoundException("Edge does not found in the database with id: " + id);
    }

    private <T> void feedId(Vertex vertex, T entity) {
        ClassRepresentation representation = this.getClassRepresentations().get(entity.getClass());
        Optional id = representation.getId();
        Object vertexId = vertex.id();
        if (Objects.nonNull(vertexId) && id.isPresent()) {
            FieldRepresentation fieldRepresentation = (FieldRepresentation)id.get();
            Field fieldId = fieldRepresentation.getNativeField();
            if (fieldRepresentation.getConverter().isPresent()) {
                AttributeConverter attributeConverter = this.getConverters().get((Class)fieldRepresentation.getConverter().get());
                Object attributeConverted = attributeConverter.convertToEntityAttribute(vertexId);
                this.getReflections().setValue(entity, fieldId, fieldRepresentation.getValue(Value.of((Object)attributeConverted)));
            } else {
                this.getReflections().setValue(entity, fieldId, fieldRepresentation.getValue(Value.of((Object)vertexId)));
            }
        }
    }

    private <T> T toEntity(Class<T> entityClass, List<Property> properties) {
        ClassRepresentation representation = this.getClassRepresentations().get(entityClass);
        Object instance = this.getReflections().newInstance(representation.getConstructor());
        return (T)this.convertEntity(properties, representation, instance);
    }

    private <T> T convertEntity(List<Property> elements, ClassRepresentation representation, T instance) {
        Map fieldsGroupByName = representation.getFieldsGroupByName();
        List names = elements.stream().map(Property::key).sorted().collect(Collectors.toList());
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        fieldsGroupByName.keySet().stream().filter(existField.or(k -> FieldType.EMBEDDED.equals((Object)((FieldRepresentation)fieldsGroupByName.get(k)).getType()))).forEach(this.feedObject(instance, elements, fieldsGroupByName));
        return instance;
    }

    private <T> Consumer<String> feedObject(T instance, List<Property> elements, Map<String, FieldRepresentation> fieldsGroupByName) {
        return k -> {
            Optional<Property> element = elements.stream().filter(c -> c.key().equals(k)).findFirst();
            FieldRepresentation field = (FieldRepresentation)fieldsGroupByName.get(k);
            if (FieldType.EMBEDDED.equals((Object)field.getType())) {
                this.setEmbeddedField(instance, elements, field);
            } else {
                this.setSingleField(instance, element, field);
            }
        };
    }

    private <T> void setSingleField(T instance, Optional<Property> element, FieldRepresentation field) {
        Object value = element.get().value();
        Optional converter = field.getConverter();
        if (converter.isPresent()) {
            AttributeConverter attributeConverter = this.getConverters().get((Class)converter.get());
            Object attributeConverted = attributeConverter.convertToEntityAttribute(value);
            this.getReflections().setValue(instance, field.getNativeField(), field.getValue(Value.of((Object)attributeConverted)));
        } else {
            this.getReflections().setValue(instance, field.getNativeField(), field.getValue(Value.of((Object)value)));
        }
    }

    private <T> void setEmbeddedField(T instance, List<Property> elements, FieldRepresentation field) {
        this.getReflections().setValue(instance, field.getNativeField(), this.toEntity(field.getNativeField().getType(), elements));
    }

    protected FieldGraph to(FieldRepresentation field, Object entityInstance) {
        Object value = this.getReflections().getValue(entityInstance, field.getNativeField());
        return FieldGraph.of(value, field);
    }
}

