/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.EntityNotFoundException;
import org.jnosql.artemis.IdNotFoundException;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.graph.DefaultEdgeEntity;
import org.jnosql.artemis.graph.DefaultEdgeTraversal;
import org.jnosql.artemis.graph.DefaultPreparedStatement;
import org.jnosql.artemis.graph.DefaultVertexTraversal;
import org.jnosql.artemis.graph.EdgeEntity;
import org.jnosql.artemis.graph.EdgeTraversal;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.GraphTemplate;
import org.jnosql.artemis.graph.GraphWorkflow;
import org.jnosql.artemis.graph.GremlinExecutor;
import org.jnosql.artemis.graph.VertexTraversal;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.FieldRepresentation;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.diana.api.NonUniqueResultException;

public abstract class AbstractGraphTemplate
implements GraphTemplate {
    private static final Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Vertex>> INITIAL_VERTEX = g -> g;
    private static final Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Edge>> INITIAL_EDGE = g -> g;
    private GremlinExecutor gremlinExecutor;

    protected abstract Graph getGraph();

    protected abstract ClassRepresentations getClassRepresentations();

    protected abstract GraphConverter getConverter();

    protected abstract GraphWorkflow getFlow();

    protected abstract Reflections getReflections();

    private GremlinExecutor getExecutor() {
        if (Objects.isNull(this.gremlinExecutor)) {
            this.gremlinExecutor = new GremlinExecutor(this.getConverter());
        }
        return this.gremlinExecutor;
    }

    @Override
    public <T> T insert(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.checkId(entity);
        UnaryOperator save = v -> v;
        return this.getFlow().flow(entity, save);
    }

    @Override
    public <T> T update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.checkId(entity);
        if (this.isIdNull(entity)) {
            throw new NullPointerException("to update a graph id cannot be null");
        }
        this.getVertex(entity).orElseThrow(() -> new EntityNotFoundException("Entity does not find in the update"));
        UnaryOperator update = e -> this.getConverter().toVertex(entity);
        return this.getFlow().flow(entity, update);
    }

    @Override
    public <T> void delete(T idValue) {
        Objects.requireNonNull(idValue, "id is required");
        List vertices = this.getTraversal().V(new Object[]{idValue}).toList();
        vertices.forEach(Element::remove);
    }

    @Override
    public <T> void deleteEdge(T idEdge) {
        Objects.requireNonNull(idEdge, "idEdge is required");
        List edges = this.getTraversal().E(new Object[]{idEdge}).toList();
        edges.forEach(Element::remove);
    }

    @Override
    public <T, ID> Optional<T> find(ID idValue) {
        Objects.requireNonNull(idValue, "id is required");
        Optional vertex = this.getTraversal().V(new Object[]{idValue}).tryNext();
        return vertex.map(this.getConverter()::toEntity);
    }

    @Override
    public <OUT, IN> EdgeEntity edge(OUT outgoing, String label, IN incoming) {
        Objects.requireNonNull(incoming, "incoming is required");
        Objects.requireNonNull(label, "label is required");
        Objects.requireNonNull(outgoing, "outgoing is required");
        this.checkId(outgoing);
        this.checkId(incoming);
        if (this.isIdNull(outgoing)) {
            throw new NullPointerException("outgoing Id field is required");
        }
        if (this.isIdNull(incoming)) {
            throw new NullPointerException("incoming Id field is required");
        }
        Vertex outVertex = this.getVertex(outgoing).orElseThrow(() -> new EntityNotFoundException("Outgoing entity does not found"));
        Vertex inVertex = this.getVertex(incoming).orElseThrow(() -> new EntityNotFoundException("Incoming entity does not found"));
        Predicate<Traverser> predicate = t -> {
            Edge e = (Edge)t.get();
            return e.inVertex().id().equals(inVertex.id()) && e.outVertex().id().equals(outVertex.id());
        };
        Optional edge = this.getTraversal().V(new Object[]{outVertex.id()}).out(new String[]{label}).has(T.id, inVertex.id()).inE(new String[]{label}).filter(predicate).tryNext();
        return edge.map(edge1 -> new DefaultEdgeEntity<Object, Object>((Edge)edge1, incoming, outgoing)).orElseGet(() -> new DefaultEdgeEntity<Object, Object>(outVertex.addEdge(label, inVertex, new Object[0]), incoming, outgoing));
    }

    @Override
    public <E> Optional<EdgeEntity> edge(E edgeId) {
        Objects.requireNonNull(edgeId, "edgeId is required");
        Optional edgeOptional = this.getTraversal().E(new Object[]{edgeId}).tryNext();
        if (edgeOptional.isPresent()) {
            Edge edge = (Edge)edgeOptional.get();
            return Optional.of(this.getConverter().toEdgeEntity(edge));
        }
        return Optional.empty();
    }

    @Override
    public <T> Collection<EdgeEntity> getEdges(T entity, Direction direction) {
        return this.getEdgesImpl(entity, direction, new String[0]);
    }

    @Override
    public <T> Collection<EdgeEntity> getEdges(T entity, Direction direction, String ... labels) {
        return this.getEdgesImpl(entity, direction, labels);
    }

    @Override
    @SafeVarargs
    public final <T> Collection<EdgeEntity> getEdges(T entity, Direction direction, Supplier<String> ... labels) {
        this.checkLabelsSupplier(labels);
        return this.getEdgesImpl(entity, direction, (String[])Stream.of(labels).map(Supplier::get).toArray(String[]::new));
    }

    @Override
    public <ID> Collection<EdgeEntity> getEdgesById(ID id, Direction direction, String ... labels) {
        return this.getEdgesByIdImpl(id, direction, labels);
    }

    @Override
    public <ID> Collection<EdgeEntity> getEdgesById(ID id, Direction direction) {
        return this.getEdgesByIdImpl(id, direction, new String[0]);
    }

    @Override
    @SafeVarargs
    public final <ID> Collection<EdgeEntity> getEdgesById(ID id, Direction direction, Supplier<String> ... labels) {
        this.checkLabelsSupplier(labels);
        return this.getEdgesByIdImpl(id, direction, (String[])Stream.of(labels).map(Supplier::get).toArray(String[]::new));
    }

    @Override
    public VertexTraversal getTraversalVertex(Object ... vertexIds) {
        if (Stream.of(vertexIds).anyMatch(Objects::isNull)) {
            throw new NullPointerException("No one vertexId element cannot be null");
        }
        return new DefaultVertexTraversal(() -> this.getTraversal().V(vertexIds), INITIAL_VERTEX, this.getConverter());
    }

    @Override
    public EdgeTraversal getTraversalEdge(Object ... edgeIds) {
        if (Stream.of(edgeIds).anyMatch(Objects::isNull)) {
            throw new NullPointerException("No one edgeId element cannot be null");
        }
        return new DefaultEdgeTraversal(() -> this.getTraversal().E(edgeIds), INITIAL_EDGE, this.getConverter());
    }

    @Override
    public Transaction getTransaction() {
        return this.getGraph().tx();
    }

    @Override
    public <T> List<T> query(String gremlin) {
        Objects.requireNonNull(gremlin, "query is required");
        return this.getExecutor().executeGremlin(this.getTraversal(), gremlin);
    }

    @Override
    public <T> Optional<T> singleResult(String gremlin) {
        List<T> entities = this.query(gremlin);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.ofNullable(entities.get(0));
        }
        throw new NonUniqueResultException("The gremlin query returns more than one result: " + gremlin);
    }

    @Override
    public PreparedStatement prepare(String gremlin) {
        Objects.requireNonNull(gremlin, "query is required");
        return new DefaultPreparedStatement(this.getExecutor(), gremlin, this.getTraversal());
    }

    protected GraphTraversalSource getTraversal() {
        return this.getGraph().traversal();
    }

    protected Iterator<Vertex> getVertices(Object id) {
        return this.getGraph().vertices(new Object[]{id});
    }

    @Override
    public long count(String label) {
        Objects.requireNonNull(label, "label is required");
        return this.getTraversal().V(new Object[0]).hasLabel(label, new String[0]).count().tryNext().orElse(0L);
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entity class is required");
        return this.count(this.getClassRepresentations().get(entityClass).getName());
    }

    private <ID> Collection<EdgeEntity> getEdgesByIdImpl(ID id, Direction direction, String ... labels) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(direction, "direction is required");
        Iterator<Vertex> vertices = this.getVertices(id);
        if (vertices.hasNext()) {
            ArrayList edges = new ArrayList();
            vertices.next().edges(direction, labels).forEachRemaining(edges::add);
            return edges.stream().map(this.getConverter()::toEdgeEntity).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private <T> Optional<Vertex> getVertex(T entity) {
        ClassRepresentation classRepresentation = this.getClassRepresentations().get(entity.getClass());
        FieldRepresentation field = (FieldRepresentation)classRepresentation.getId().get();
        Object id = this.getReflections().getValue(entity, field.getNativeField());
        Iterator<Vertex> vertices = this.getVertices(id);
        if (vertices.hasNext()) {
            return Optional.of(vertices.next());
        }
        return Optional.empty();
    }

    private <T> Collection<EdgeEntity> getEdgesImpl(T entity, Direction direction, String ... labels) {
        Objects.requireNonNull(entity, "entity is required");
        if (this.isIdNull(entity)) {
            throw new NullPointerException("Entity id is required");
        }
        if (!this.getVertex(entity).isPresent()) {
            return Collections.emptyList();
        }
        Object id = this.getConverter().toVertex(entity).id();
        return this.getEdgesByIdImpl(id, direction, labels);
    }

    private void checkLabelsSupplier(Supplier<String>[] labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("Item cannot be null");
        }
    }

    private <T> boolean isIdNull(T entity) {
        ClassRepresentation classRepresentation = this.getClassRepresentations().get(entity.getClass());
        FieldRepresentation field = (FieldRepresentation)classRepresentation.getId().get();
        return Objects.isNull(this.getReflections().getValue(entity, field.getNativeField()));
    }

    private <T> void checkId(T entity) {
        ClassRepresentation classRepresentation = this.getClassRepresentations().get(entity.getClass());
        classRepresentation.getId().orElseThrow(() -> IdNotFoundException.newInstance(entity.getClass()));
    }
}

