/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.graph.AbstractEdgeTraversal;
import org.jnosql.artemis.graph.DefaultEdgeRepeatTraversal;
import org.jnosql.artemis.graph.DefaultEdgeTraversalOrder;
import org.jnosql.artemis.graph.DefaultValueMapTraversal;
import org.jnosql.artemis.graph.DefaultVertexTraversal;
import org.jnosql.artemis.graph.EdgeEntity;
import org.jnosql.artemis.graph.EdgeRepeatTraversal;
import org.jnosql.artemis.graph.EdgeTraversal;
import org.jnosql.artemis.graph.EdgeTraversalOrder;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.ValueMapTraversal;
import org.jnosql.artemis.graph.VertexTraversal;
import org.jnosql.diana.api.NonUniqueResultException;

class DefaultEdgeTraversal
extends AbstractEdgeTraversal
implements EdgeTraversal {
    DefaultEdgeTraversal(Supplier<GraphTraversal<?, ?>> supplier, Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Edge>> flow, GraphConverter converter) {
        super(supplier, flow, converter);
    }

    @Override
    public EdgeTraversal has(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey)), this.converter);
    }

    @Override
    public EdgeTraversal has(String propertyKey, Object value) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, value)), this.converter);
    }

    @Override
    public EdgeTraversal has(String propertyKey, P<?> predicate) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, predicate)), this.converter);
    }

    @Override
    public EdgeTraversal has(T accessor, Object value) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, value)), this.converter);
    }

    @Override
    public EdgeTraversal has(T accessor, P<?> predicate) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, predicate)), this.converter);
    }

    @Override
    public EdgeTraversal hasNot(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.hasNot(propertyKey)), this.converter);
    }

    @Override
    public EdgeTraversal filter(Predicate<EdgeEntity> predicate) {
        Objects.requireNonNull(predicate, "predicat is required");
        Predicate<Traverser> p = e -> predicate.test(this.converter.toEdgeEntity((Edge)e.get()));
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.filter(p)), this.converter);
    }

    @Override
    public EdgeTraversal limit(long limit) {
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.limit(limit)), this.converter);
    }

    @Override
    public EdgeTraversal range(long start, long end) {
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.range(start, end)), this.converter);
    }

    @Override
    public EdgeRepeatTraversal repeat() {
        return new DefaultEdgeRepeatTraversal(this.supplier, this.flow, this.converter);
    }

    @Override
    public VertexTraversal inV() {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(GraphTraversal::inV), this.converter);
    }

    @Override
    public VertexTraversal outV() {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(GraphTraversal::outV), this.converter);
    }

    @Override
    public VertexTraversal bothV() {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(GraphTraversal::bothV), this.converter);
    }

    @Override
    public Optional<EdgeEntity> next() {
        Optional edgeOptional = ((GraphTraversal)this.flow.apply(this.supplier.get())).tryNext();
        if (edgeOptional.isPresent()) {
            Edge edge = (Edge)edgeOptional.get();
            return Optional.of(this.converter.toEdgeEntity(edge));
        }
        return Optional.empty();
    }

    @Override
    public Optional<EdgeEntity> getSingleResult() {
        List<EdgeEntity> result = this.getResultList();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() == 1) {
            return Optional.of(result.get(0));
        }
        throw new NonUniqueResultException("The Edge traversal query returns more than one result");
    }

    @Override
    public List<EdgeEntity> getResultList() {
        return this.stream().collect(Collectors.toList());
    }

    @Override
    public Stream<EdgeEntity> stream() {
        return ((GraphTraversal)this.flow.apply(this.supplier.get())).toList().stream().map(this.converter::toEdgeEntity);
    }

    @Override
    public Stream<EdgeEntity> next(int limit) {
        return ((GraphTraversal)this.flow.apply(this.supplier.get())).next(limit).stream().map(this.converter::toEdgeEntity);
    }

    @Override
    public ValueMapTraversal valueMap(String ... propertyKeys) {
        return new DefaultValueMapTraversal(this.supplier, this.flow.andThen(g -> g.valueMap(propertyKeys)));
    }

    @Override
    public EdgeTraversalOrder orderBy(String property) {
        Objects.requireNonNull(property, "property is required");
        return new DefaultEdgeTraversalOrder(this.supplier, this.flow, this.converter, property);
    }

    @Override
    public long count() {
        return ((GraphTraversal)this.flow.apply(this.supplier.get())).count().tryNext().orElse(0L);
    }
}

