/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.graph.AbstractEdgeTraversal;
import org.jnosql.artemis.graph.DefaultEdgeTraversal;
import org.jnosql.artemis.graph.EdgeTraversal;
import org.jnosql.artemis.graph.EdgeTraversalOrder;
import org.jnosql.artemis.graph.GraphConverter;

final class DefaultEdgeTraversalOrder
extends AbstractEdgeTraversal
implements EdgeTraversalOrder {
    private final String property;

    DefaultEdgeTraversalOrder(Supplier<GraphTraversal<?, ?>> supplier, Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Edge>> flow, GraphConverter converter, String property) {
        super(supplier, flow, converter);
        this.property = property;
    }

    @Override
    public EdgeTraversal asc() {
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.order().by(this.property, (Comparator)Order.incr)), this.converter);
    }

    @Override
    public EdgeTraversal desc() {
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.order().by(this.property, (Comparator)Order.decr)), this.converter);
    }
}

