/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.EntityPostPersit;
import org.jnosql.artemis.EntityPrePersist;
import org.jnosql.artemis.graph.EntityGraphPostPersist;
import org.jnosql.artemis.graph.EntityGraphPrePersist;
import org.jnosql.artemis.graph.GraphEntityPostPersist;
import org.jnosql.artemis.graph.GraphEntityPrePersist;
import org.jnosql.artemis.graph.GraphEventPersistManager;

@ApplicationScoped
class DefaultGraphEventPersistManager
implements GraphEventPersistManager {
    @Inject
    private Event<GraphEntityPrePersist> graphEntityPrePersistEvent;
    @Inject
    private Event<GraphEntityPostPersist> graphEntityPostPersistEvent;
    @Inject
    private Event<EntityPrePersist> entityPrePersistEvent;
    @Inject
    private Event<EntityPostPersit> entityPostPersitEvent;
    @Inject
    private Event<EntityGraphPrePersist> entityGraphPrePersist;
    @Inject
    private Event<EntityGraphPostPersist> entityGraphPostPersist;

    DefaultGraphEventPersistManager() {
    }

    @Override
    public void firePreGraph(Vertex entity) {
        this.graphEntityPrePersistEvent.fire((Object)GraphEntityPrePersist.of(entity));
    }

    @Override
    public void firePostGraph(Vertex entity) {
        this.graphEntityPostPersistEvent.fire((Object)GraphEntityPostPersist.of(entity));
    }

    @Override
    public <T> void firePreEntity(T entity) {
        this.entityPrePersistEvent.fire((Object)EntityPrePersist.of(entity));
    }

    @Override
    public <T> void firePostEntity(T entity) {
        this.entityPostPersitEvent.fire((Object)EntityPostPersit.of(entity));
    }

    @Override
    public <T> void firePreGraphEntity(T entity) {
        this.entityGraphPrePersist.fire((Object)EntityGraphPrePersist.of(entity));
    }

    @Override
    public <T> void firePostGraphEntity(T entity) {
        this.entityGraphPostPersist.fire((Object)EntityGraphPostPersist.of(entity));
    }
}

