/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.graph.DefaultGraphConverter;
import org.jnosql.artemis.graph.DefaultGraphTemplate;
import org.jnosql.artemis.graph.DefaultGraphTraversalSourceConverter;
import org.jnosql.artemis.graph.DefaultGraphTraversalSourceTemplate;
import org.jnosql.artemis.graph.DefaultGraphWorkflow;
import org.jnosql.artemis.graph.GraphEventPersistManager;
import org.jnosql.artemis.graph.GraphTemplate;
import org.jnosql.artemis.graph.GraphTemplateProducer;
import org.jnosql.artemis.graph.GraphTraversalSourceSupplier;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

class DefaultGraphTemplateProducer
implements GraphTemplateProducer {
    @Inject
    private ClassRepresentations classRepresentations;
    @Inject
    private Reflections reflections;
    @Inject
    private Converters converters;
    @Inject
    private GraphEventPersistManager persistManager;

    DefaultGraphTemplateProducer() {
    }

    public GraphTemplate get(Graph graph) {
        Objects.requireNonNull(graph, "graph is required");
        SingleInstance<Graph> instance = new SingleInstance<Graph>(graph);
        DefaultGraphConverter converter = new DefaultGraphConverter(this.classRepresentations, this.reflections, this.converters, instance);
        DefaultGraphWorkflow workflow = new DefaultGraphWorkflow(this.persistManager, converter);
        return new DefaultGraphTemplate(instance, this.classRepresentations, converter, workflow, this.reflections);
    }

    public GraphTemplate get(GraphTraversalSourceSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        SingleInstance<GraphTraversalSourceSupplier> instance = new SingleInstance<GraphTraversalSourceSupplier>(supplier);
        DefaultGraphTraversalSourceConverter converter = new DefaultGraphTraversalSourceConverter(this.classRepresentations, this.reflections, this.converters, instance);
        DefaultGraphWorkflow workflow = new DefaultGraphWorkflow(this.persistManager, converter);
        return new DefaultGraphTraversalSourceTemplate(instance, this.classRepresentations, converter, workflow, this.reflections);
    }

    class SingleInstance<T>
    implements Instance<T> {
        private final T instance;

        SingleInstance(T instance) {
            this.instance = instance;
        }

        public Instance<T> select(Annotation ... annotations) {
            throw new UnsupportedOperationException("this method is not support");
        }

        public <U extends T> Instance<U> select(Class<U> aClass, Annotation ... annotations) {
            throw new UnsupportedOperationException("this method is not support");
        }

        public <U extends T> Instance<U> select(TypeLiteral<U> typeLiteral, Annotation ... annotations) {
            throw new UnsupportedOperationException("this method is not support");
        }

        public boolean isUnsatisfied() {
            return false;
        }

        public boolean isAmbiguous() {
            return false;
        }

        public void destroy(T t) {
        }

        public Iterator<T> iterator() {
            return Collections.singletonList(this.instance).iterator();
        }

        public T get() {
            return this.instance;
        }
    }
}

