/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.EntityNotFoundException;
import org.jnosql.artemis.graph.AbstractGraphConverter;
import org.jnosql.artemis.graph.EdgeEntity;
import org.jnosql.artemis.graph.FieldGraph;
import org.jnosql.artemis.graph.GraphTraversalSourceOperation;
import org.jnosql.artemis.graph.GraphTraversalSourceSupplier;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.FieldRepresentation;
import org.jnosql.artemis.reflection.Reflections;

@GraphTraversalSourceOperation
class DefaultGraphTraversalSourceConverter
extends AbstractGraphConverter {
    private ClassRepresentations classRepresentations;
    private Reflections reflections;
    private Converters converters;
    private Instance<GraphTraversalSourceSupplier> suppliers;

    @Inject
    DefaultGraphTraversalSourceConverter(ClassRepresentations classRepresentations, Reflections reflections, Converters converters, Instance<GraphTraversalSourceSupplier> suppliers) {
        this.classRepresentations = classRepresentations;
        this.reflections = reflections;
        this.converters = converters;
        this.suppliers = suppliers;
    }

    DefaultGraphTraversalSourceConverter() {
    }

    @Override
    protected ClassRepresentations getClassRepresentations() {
        return this.classRepresentations;
    }

    @Override
    protected Reflections getReflections() {
        return this.reflections;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    protected Graph getGraph() {
        throw new UnsupportedOperationException("GraphTraversalSource does not support graph instance");
    }

    @Override
    public <T> Vertex toVertex(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        ClassRepresentation representation = this.getClassRepresentations().get(entity.getClass());
        String label = representation.getName();
        List fields = representation.getFields().stream().map(f -> this.to((FieldRepresentation)f, entity)).filter(FieldGraph::isNotEmpty).collect(Collectors.toList());
        Optional<FieldGraph> id = fields.stream().filter(FieldGraph::isId).findFirst();
        Function<Property, Vertex> findVertexOrCreateWithId = p -> {
            GraphTraversal vertices = this.getTraversalSource().V(new Object[]{p.value()});
            return vertices.hasNext() ? (Vertex)vertices.next() : (Vertex)this.getTraversalSource().addV(label).property((Object)T.id, p.value(), new Object[0]).next();
        };
        Vertex vertex = id.map(i -> i.toElement(this.getConverters())).map(findVertexOrCreateWithId).orElseGet(() -> (Vertex)this.getTraversalSource().addV(label).next());
        fields.stream().filter(FieldGraph::isNotId).flatMap(f -> f.toElements(this, this.getConverters()).stream()).forEach(p -> vertex.property(p.key(), p.value()));
        return vertex;
    }

    @Override
    public Edge toEdge(EdgeEntity edge) {
        Objects.requireNonNull(edge, "vertex is required");
        Object id = edge.getId().get();
        GraphTraversal edges = this.getTraversalSource().E(new Object[]{id});
        if (edges.hasNext()) {
            return (Edge)edges.next();
        }
        throw new EntityNotFoundException("Edge does not found in the database with id: " + id);
    }

    private GraphTraversalSource getTraversalSource() {
        return (GraphTraversalSource)((GraphTraversalSourceSupplier)this.suppliers.get()).get();
    }
}

