/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.Iterator;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.graph.AbstractGraphTemplate;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.GraphTraversalSourceOperation;
import org.jnosql.artemis.graph.GraphTraversalSourceSupplier;
import org.jnosql.artemis.graph.GraphWorkflow;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

@GraphTraversalSourceOperation
class DefaultGraphTraversalSourceTemplate
extends AbstractGraphTemplate {
    private Instance<GraphTraversalSourceSupplier> supplierInstance;
    private ClassRepresentations classRepresentations;
    private GraphConverter converter;
    private GraphWorkflow workflow;
    private Reflections reflections;

    @Inject
    DefaultGraphTraversalSourceTemplate(Instance<GraphTraversalSourceSupplier> supplierInstance, ClassRepresentations classRepresentations, @GraphTraversalSourceOperation GraphConverter converter, GraphWorkflow workflow, Reflections reflections) {
        this.supplierInstance = supplierInstance;
        this.classRepresentations = classRepresentations;
        this.converter = converter;
        this.workflow = workflow;
        this.reflections = reflections;
    }

    DefaultGraphTraversalSourceTemplate() {
    }

    @Override
    protected Graph getGraph() {
        throw new UnsupportedOperationException("The GraphTraversalSourceOperation implementation does not support Graph");
    }

    @Override
    public Transaction getTransaction() {
        return this.getTraversal().tx();
    }

    @Override
    protected GraphTraversalSource getTraversal() {
        return (GraphTraversalSource)((GraphTraversalSourceSupplier)this.supplierInstance.get()).get();
    }

    @Override
    protected ClassRepresentations getClassRepresentations() {
        return this.classRepresentations;
    }

    @Override
    protected GraphConverter getConverter() {
        return this.converter;
    }

    @Override
    protected GraphWorkflow getFlow() {
        return this.workflow;
    }

    @Override
    protected Reflections getReflections() {
        return this.reflections;
    }

    @Override
    protected Iterator<Vertex> getVertices(Object id) {
        return this.getTraversal().V(new Object[]{id}).toList().iterator();
    }
}

