/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.graph.GremlinExecutor;
import org.jnosql.diana.api.NonUniqueResultException;

final class DefaultPreparedStatement
implements PreparedStatement {
    private final GremlinExecutor executor;
    private final String gremlin;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final GraphTraversalSource traversalSource;

    DefaultPreparedStatement(GremlinExecutor executor, String gremlin, GraphTraversalSource traversalSource) {
        this.executor = executor;
        this.gremlin = gremlin;
        this.traversalSource = traversalSource;
    }

    public PreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.params.put(name, value);
        return this;
    }

    public <T> List<T> getResultList() {
        return this.executor.executeGremlin(this.traversalSource, this.gremlin, this.params);
    }

    public <T> Optional<T> getSingleResult() {
        List<T> entities = this.getResultList();
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.ofNullable(entities.get(0));
        }
        throw new NonUniqueResultException("There is more than one result found in the gremlin query: " + this.gremlin);
    }
}

