/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.Entity;
import org.jnosql.artemis.graph.AbstractVertexTraversal;
import org.jnosql.artemis.graph.DefaultEdgeTraversal;
import org.jnosql.artemis.graph.DefaultValueMapTraversal;
import org.jnosql.artemis.graph.DefaultVertexRepeatTraversal;
import org.jnosql.artemis.graph.DefaultVertexTraversalOrder;
import org.jnosql.artemis.graph.EdgeTraversal;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.ValueMapTraversal;
import org.jnosql.artemis.graph.VertexRepeatTraversal;
import org.jnosql.artemis.graph.VertexTraversal;
import org.jnosql.artemis.graph.VertexTraversalOrder;
import org.jnosql.diana.api.NonUniqueResultException;

class DefaultVertexTraversal
extends AbstractVertexTraversal
implements VertexTraversal {
    private static final Predicate<String> IS_EMPTY = String::isEmpty;
    private static final Predicate<String> NOT_EMPTY = IS_EMPTY.negate();

    DefaultVertexTraversal(Supplier<GraphTraversal<?, ?>> supplier, Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Vertex>> flow, GraphConverter converter) {
        super(supplier, flow, converter);
    }

    @Override
    public VertexTraversal has(String propertyKey, Object value) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, value)), this.converter);
    }

    @Override
    public VertexTraversal has(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey)), this.converter);
    }

    @Override
    public VertexTraversal has(String propertyKey, P<?> predicate) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, predicate)), this.converter);
    }

    @Override
    public VertexTraversal has(T accessor, Object value) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, value)), this.converter);
    }

    @Override
    public VertexTraversal has(T accessor, P<?> predicate) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, predicate)), this.converter);
    }

    @Override
    public VertexTraversal out(String ... labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one label element cannot be null");
        }
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.out(labels)), this.converter);
    }

    @Override
    public <T> VertexTraversal filter(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is required");
        Predicate<Traverser> p = v -> predicate.test(this.converter.toEntity((Vertex)v.get()));
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.filter(p)), this.converter);
    }

    @Override
    public EdgeTraversal outE(String ... edgeLabels) {
        if (Stream.of(edgeLabels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one edgeLabels element cannot be null");
        }
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.outE(edgeLabels)), this.converter);
    }

    @Override
    public VertexTraversal in(String ... labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one label element cannot be null");
        }
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.in(labels)), this.converter);
    }

    @Override
    public EdgeTraversal inE(String ... edgeLabels) {
        if (Stream.of(edgeLabels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one edgeLabels element cannot be null");
        }
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.inE(edgeLabels)), this.converter);
    }

    @Override
    public VertexTraversal both(String ... labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one label element cannot be null");
        }
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.both(labels)), this.converter);
    }

    @Override
    public EdgeTraversal bothE(String ... edgeLabels) {
        if (Stream.of(edgeLabels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one edgeLabels element cannot be null");
        }
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.bothE(edgeLabels)), this.converter);
    }

    @Override
    public VertexRepeatTraversal repeat() {
        return new DefaultVertexRepeatTraversal(this.supplier, this.flow, this.converter);
    }

    @Override
    public VertexTraversal limit(long limit) {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.limit(limit)), this.converter);
    }

    @Override
    public VertexTraversal range(long start, long end) {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.range(start, end)), this.converter);
    }

    @Override
    public VertexTraversal hasLabel(String label) {
        Objects.requireNonNull(label, "label is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(label, new String[0])), this.converter);
    }

    @Override
    public <T> VertexTraversal hasLabel(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Entity entity = entityClass.getAnnotation(Entity.class);
        String label = Optional.ofNullable(entity).map(Entity::value).filter(NOT_EMPTY).orElse(entityClass.getSimpleName());
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(label, new String[0])), this.converter);
    }

    @Override
    public <T> VertexTraversal hasLabel(P<String> predicate) {
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(predicate)), this.converter);
    }

    @Override
    public VertexTraversal hasNot(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasNot(propertyKey)), this.converter);
    }

    @Override
    public <T> Optional<T> next() {
        Optional vertex = ((GraphTraversal)this.flow.apply(this.supplier.get())).tryNext();
        return vertex.map(this.converter::toEntity);
    }

    @Override
    public <T> Stream<T> stream() {
        return ((GraphTraversal)this.flow.apply(this.supplier.get())).toList().stream().map(this.converter::toEntity);
    }

    @Override
    public <T> Optional<T> getSingleResult() {
        List<T> result = this.getResultList();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() == 1) {
            return Optional.of(result.get(0));
        }
        throw new NonUniqueResultException("The Vertex traversal query returns more than one result");
    }

    @Override
    public <T> List<T> getResultList() {
        Stream stream = this.stream();
        return stream.collect(Collectors.toList());
    }

    @Override
    public <T> Stream<T> next(int limit) {
        return ((GraphTraversal)this.flow.apply(this.supplier.get())).next(limit).stream().map(this.converter::toEntity);
    }

    @Override
    public ValueMapTraversal valueMap(String ... propertyKeys) {
        return new DefaultValueMapTraversal(this.supplier, this.flow.andThen(g -> g.valueMap(propertyKeys)));
    }

    @Override
    public long count() {
        return ((GraphTraversal)this.flow.apply(this.supplier.get())).count().tryNext().orElse(0L);
    }

    @Override
    public VertexTraversalOrder orderBy(String property) {
        Objects.requireNonNull(property, "property is required");
        return new DefaultVertexTraversalOrder(this.supplier, this.flow, this.converter, property);
    }
}

