/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.Entity;
import org.jnosql.artemis.graph.AbstractVertexTraversal;
import org.jnosql.artemis.graph.DefaultVertexTraversal;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.VertexTraversal;
import org.jnosql.artemis.graph.VertexUntilTraversal;

class DefaultVertexUntilTraversal
extends AbstractVertexTraversal
implements VertexUntilTraversal {
    DefaultVertexUntilTraversal(Supplier<GraphTraversal<?, ?>> supplier, Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Vertex>> flow, GraphConverter converter) {
        super(supplier, flow, converter);
    }

    @Override
    public VertexTraversal has(String propertyKey, Object value) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(value, "value is required");
        GraphTraversal condition = __.has((String)propertyKey, (Object)value);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$has$0((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal has(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        GraphTraversal condition = __.has((String)propertyKey);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$has$1((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal has(String propertyKey, P<?> predicate) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(predicate, "predicate is required");
        GraphTraversal condition = __.has((String)propertyKey, predicate);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$has$2((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal has(T accessor, Object value) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(value, "value is required");
        GraphTraversal condition = __.has((T)accessor, (Object)value);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$has$3((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal has(T accessor, P<?> predicate) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(predicate, "predicate is required");
        GraphTraversal condition = __.has((T)accessor, predicate);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$has$4((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal hasNot(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        GraphTraversal condition = __.hasNot((String)propertyKey);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$hasNot$5((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal out(String ... labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one label element cannot be null");
        }
        GraphTraversal condition = __.out((String[])labels);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$out$6((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal in(String ... labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one label element cannot be null");
        }
        GraphTraversal condition = __.in((String[])labels);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$in$7((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal both(String ... labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new NullPointerException("The no one label element cannot be null");
        }
        GraphTraversal condition = __.both((String[])labels);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$both$8((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public VertexTraversal hasLabel(String label) {
        Objects.requireNonNull(label, "label is required");
        GraphTraversal condition = __.hasLabel((String)label, (String[])new String[0]);
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(arg_0 -> DefaultVertexUntilTraversal.lambda$hasLabel$9((Traversal)condition, arg_0)), this.converter);
    }

    @Override
    public <T> VertexTraversal hasLabel(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Entity entity = entityClass.getAnnotation(Entity.class);
        String label = Optional.ofNullable(entity).map(Entity::value).orElse(entityClass.getName());
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(label, new String[0])), this.converter);
    }

    @Override
    public <T> VertexTraversal hasLabel(P<String> predicate) {
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(predicate)), this.converter);
    }

    private static /* synthetic */ GraphTraversal lambda$hasLabel$9(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$both$8(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$in$7(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$out$6(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$hasNot$5(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$has$4(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$has$3(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$has$2(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$has$1(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }

    private static /* synthetic */ GraphTraversal lambda$has$0(Traversal condition, GraphTraversal g) {
        return g.until(condition);
    }
}

