/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.jnosql.artemis.graph.DefaultEdgeEntity;
import org.jnosql.diana.api.Value;

public interface EdgeEntity {
    public Value getId();

    public String getLabel();

    public <T> T getIncoming();

    public <T> T getOutgoing();

    public List<Property> getProperties();

    public void add(String var1, Object var2);

    public void add(String var1, Value var2);

    public void remove(String var1);

    public Optional<Value> get(String var1);

    public boolean isEmpty();

    public int size();

    public void delete();

    public static <OUT, IN> EdgeEntity of(OUT outgoing, Edge edge, IN incoming) {
        Objects.requireNonNull(outgoing, "outgoing is required");
        Objects.requireNonNull(edge, "edge is required");
        Objects.requireNonNull(incoming, "incoming is required");
        return new DefaultEdgeEntity<OUT, IN>(edge, incoming, outgoing);
    }
}

