/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.jnosql.artemis.AttributeConverter;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.graph.DefaultProperty;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.reflection.FieldRepresentation;
import org.jnosql.artemis.reflection.FieldType;

final class FieldGraph {
    private final Object value;
    private final FieldRepresentation field;

    private FieldGraph(Object value, FieldRepresentation field) {
        this.value = value;
        this.field = field;
    }

    public Object getValue() {
        return this.value;
    }

    public FieldRepresentation getField() {
        return this.field;
    }

    public boolean isNotEmpty() {
        return this.value != null;
    }

    public boolean isId() {
        return this.field.isId();
    }

    public boolean isNotId() {
        return !this.isId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldGraph)) {
            return false;
        }
        FieldGraph that = (FieldGraph)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.field);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FieldGraph{");
        sb.append("value=").append(this.value);
        sb.append(", field=").append(this.field);
        sb.append('}');
        return sb.toString();
    }

    public static FieldGraph of(Object value, FieldRepresentation field) {
        return new FieldGraph(value, field);
    }

    public List<Property<?>> toElements(GraphConverter converter, Converters converters) {
        if (FieldType.EMBEDDED.equals((Object)this.field.getType())) {
            return converter.getProperties(this.value);
        }
        Optional optionalConverter = this.field.getConverter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((Class)optionalConverter.get());
            return Collections.singletonList(DefaultProperty.of(this.field.getName(), attributeConverter.convertToDatabaseColumn(this.value)));
        }
        return Collections.singletonList(DefaultProperty.of(this.field.getName(), this.value));
    }

    public Property toElement(Converters converters) {
        Optional optionalConverter = this.field.getConverter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((Class)optionalConverter.get());
            return DefaultProperty.of(this.field.getName(), attributeConverter.convertToDatabaseColumn(this.value));
        }
        return DefaultProperty.of(this.field.getName(), this.value);
    }
}

