/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.graph.EdgeEntity;
import org.jnosql.artemis.graph.EdgeTraversal;
import org.jnosql.artemis.graph.VertexTraversal;

public interface GraphTemplate {
    public <T> T insert(T var1);

    public <T> T update(T var1);

    public <T> void delete(T var1);

    public <T> void deleteEdge(T var1);

    public <T, ID> Optional<T> find(ID var1);

    public <OUT, IN> EdgeEntity edge(OUT var1, String var2, IN var3);

    default public <OUT, IN> EdgeEntity edge(OUT outgoing, Supplier<String> label, IN incoming) {
        Objects.requireNonNull(label, "supplier is required");
        return this.edge(outgoing, label.get(), incoming);
    }

    public <ID> Collection<EdgeEntity> getEdgesById(ID var1, Direction var2, String ... var3);

    public <ID> Collection<EdgeEntity> getEdgesById(ID var1, Direction var2, Supplier<String> ... var3);

    public <ID> Collection<EdgeEntity> getEdgesById(ID var1, Direction var2);

    public <T> Collection<EdgeEntity> getEdges(T var1, Direction var2, String ... var3);

    public <T> Collection<EdgeEntity> getEdges(T var1, Direction var2, Supplier<String> ... var3);

    public <T> Collection<EdgeEntity> getEdges(T var1, Direction var2);

    public <E> Optional<EdgeEntity> edge(E var1);

    public VertexTraversal getTraversalVertex(Object ... var1);

    public EdgeTraversal getTraversalEdge(Object ... var1);

    public Transaction getTransaction();

    public <T> List<T> query(String var1);

    public <T> Optional<T> singleResult(String var1);

    public PreparedStatement prepare(String var1);

    public long count(String var1);

    public <T> long count(Class<T> var1);
}

