/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.GremlinQueryException;

final class GremlinExecutor {
    private final GraphConverter converter;
    private static final ScriptEngine ENGINE = new GremlinGroovyScriptEngine();

    GremlinExecutor(GraphConverter converter) {
        this.converter = converter;
    }

    <T> List<T> executeGremlin(GraphTraversalSource traversalSource, String gremlin) {
        return this.executeGremlin(traversalSource, gremlin, Collections.emptyMap());
    }

    <T> List<T> executeGremlin(GraphTraversalSource traversalSource, String gremlin, Map<String, Object> params) {
        try {
            Bindings bindings = ENGINE.createBindings();
            bindings.put("g", (Object)traversalSource);
            params.forEach(bindings::put);
            Object eval = ENGINE.eval(gremlin, bindings);
            if (eval instanceof GraphTraversal) {
                return this.convertToList(((GraphTraversal)GraphTraversal.class.cast(eval)).toList());
            }
            if (eval instanceof Iterable) {
                return this.convertToList((Iterable)Iterable.class.cast(eval));
            }
            return Collections.singletonList(eval);
        }
        catch (ScriptException e) {
            throw new GremlinQueryException("There is an error when executed the gremlin query: " + gremlin, e);
        }
    }

    private <T> List<T> convertToList(Iterable<?> iterable) {
        ArrayList<Object> entities = new ArrayList<Object>();
        for (Object entity : iterable) {
            entities.add(this.getElement(entity));
        }
        return entities;
    }

    private Object getElement(Object entity) {
        if (entity instanceof Vertex) {
            return this.converter.toEntity((Vertex)Vertex.class.cast(entity));
        }
        if (entity instanceof Edge) {
            return this.converter.toEdgeEntity((Edge)Edge.class.cast(entity));
        }
        return entity;
    }
}

