/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph;

import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.jnosql.artemis.graph.Transactional;

@Transactional
@Interceptor
@Alternative
@Priority(value=2000)
class TransactionalInterceptor {
    @Inject
    private Instance<Graph> graph;

    TransactionalInterceptor() {
    }

    @AroundInvoke
    public Object manageTransaction(InvocationContext context) throws Exception {
        Transaction transaction = ((Graph)this.graph.get()).tx();
        if (!transaction.isOpen()) {
            transaction.open();
        }
        try {
            Object proceed = context.proceed();
            transaction.commit();
            return proceed;
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }
}

