/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jnosql.artemis.Param;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.Query;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.GraphTemplate;
import org.jnosql.artemis.graph.query.GraphQueryParser;
import org.jnosql.artemis.graph.query.GraphRepositoryType;
import org.jnosql.artemis.graph.query.ReturnTypeConverterUtil;
import org.jnosql.artemis.reflection.ClassRepresentation;

abstract class AbstractGraphRepositoryProxy<T, ID>
implements InvocationHandler {
    AbstractGraphRepositoryProxy() {
    }

    protected abstract ClassRepresentation getClassRepresentation();

    protected abstract Repository getRepository();

    protected abstract GraphQueryParser getQueryParser();

    protected abstract Graph getGraph();

    protected abstract GraphConverter getConverter();

    protected abstract GraphTemplate getTemplate();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        GraphRepositoryType type = GraphRepositoryType.of(method, args);
        Class typeClass = this.getClassRepresentation().getClassInstance();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                return this.executeFindByMethod(method, args, methodName);
            }
            case DELETE_BY: {
                return this.executeDeleteMethod(args, methodName);
            }
            case FIND_ALL: {
                return this.executeFindAll(method, args);
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case UNKNOWN: 
            case JNOSQL_QUERY: {
                return this.getJnosqlQuery(method, args, typeClass);
            }
        }
        return Void.class;
    }

    private Object executeDeleteMethod(Object[] args, String methodName) {
        GraphTraversal traversal = this.getGraph().traversal().V(new Object[0]);
        this.getQueryParser().deleteByParse(methodName, args, this.getClassRepresentation(), traversal);
        List vertices = traversal.toList();
        for (Object element : vertices) {
            if (!Element.class.isInstance(element)) continue;
            ((Element)Element.class.cast(element)).remove();
        }
        return Void.class;
    }

    private Object executeFindByMethod(Method method, Object[] args, String methodName) {
        Class classInstance = this.getClassRepresentation().getClassInstance();
        GraphTraversal traversal = this.getGraph().traversal().V(new Object[0]);
        this.getQueryParser().findByParse(methodName, args, this.getClassRepresentation(), traversal);
        List vertices = traversal.hasLabel(this.getClassRepresentation().getName(), new String[0]).toList();
        Stream<Object> stream = vertices.stream().map(this.getConverter()::toEntity);
        return ReturnTypeConverterUtil.returnObject(stream, classInstance, method);
    }

    private Object executeFindAll(Method method, Object[] args) {
        Class classInstance = this.getClassRepresentation().getClassInstance();
        GraphTraversal traversal = this.getGraph().traversal().V(new Object[0]);
        List vertices = traversal.hasLabel(this.getClassRepresentation().getName(), new String[0]).toList();
        Stream<Object> stream = vertices.stream().map(this.getConverter()::toEntity);
        return ReturnTypeConverterUtil.returnObject(stream, classInstance, method);
    }

    private Object getJnosqlQuery(Method method, Object[] args, Class<?> typeClass) {
        List entities;
        String value = method.getAnnotation(Query.class).value();
        Map<String, Object> params = this.getParams(method, args);
        if (params.isEmpty()) {
            entities = this.getTemplate().query(value);
        } else {
            PreparedStatement prepare = this.getTemplate().prepare(value);
            params.entrySet().stream().forEach(e -> prepare.bind((String)e.getKey(), e.getValue()));
            entities = prepare.getResultList();
        }
        return ReturnTypeConverterUtil.returnObject(entities, typeClass, method);
    }

    private Map<String, Object> getParams(Method method, Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Parameter parameter = parameters[index];
            Param param = parameter.getAnnotation(Param.class);
            if (!Objects.nonNull(param)) continue;
            params.put(param.value(), args[index]);
        }
        return params;
    }
}

