/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.query;

import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.GraphRepositoryProducer;
import org.jnosql.artemis.graph.GraphTemplate;
import org.jnosql.artemis.graph.GraphTemplateProducer;
import org.jnosql.artemis.graph.query.GraphRepositoryProxy;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

@ApplicationScoped
class DefaultGraphRepositoryProducer
implements GraphRepositoryProducer {
    @Inject
    private ClassRepresentations classRepresentations;
    @Inject
    private Reflections reflections;
    @Inject
    private GraphConverter converter;
    @Inject
    private GraphTemplateProducer producer;

    DefaultGraphRepositoryProducer() {
    }

    @Override
    public <E, ID, T extends Repository<E, ID>> T get(Class<T> repositoryClass, Graph manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        Object template = this.producer.get(manager);
        GraphRepositoryProxy handler = new GraphRepositoryProxy((GraphTemplate)template, this.classRepresentations, repositoryClass, this.reflections, manager, this.converter);
        return (T)((Repository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

