/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.query;

import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.jnosql.artemis.graph.query.GraphQueryParserUtil;
import org.jnosql.artemis.graph.query.TokenProcessorType;
import org.jnosql.artemis.reflection.ClassRepresentation;

class GraphQueryParser {
    private static final String PREFIX_FIND_BY = "findBy";
    private static final String PREFIX_DELETE_BY = "deleteBy";
    private static final String TOKENIZER = "(?=And)";
    private static final String EMPTY = "";

    GraphQueryParser() {
    }

    public void findByParse(String methodName, Object[] args, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
        this.parse(methodName, args, representation, traversal, PREFIX_FIND_BY);
    }

    public void deleteByParse(String methodName, Object[] args, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
        this.parse(methodName, args, representation, traversal, PREFIX_DELETE_BY);
    }

    private void parse(String methodName, Object[] args, ClassRepresentation representation, GraphTraversal<?, ?> traversal, String parse) {
        String[] tokens = methodName.replace(parse, EMPTY).split(TOKENIZER);
        int index = 0;
        for (String token : tokens) {
            if (token.startsWith("And")) {
                index = GraphQueryParserUtil.and(args, index, token, methodName, representation, traversal);
                continue;
            }
            GraphQueryParserUtil.feedTraversal(token, index, args, methodName, representation, traversal);
            if (!TokenProcessorType.isNotGraphToken(token)) continue;
            ++index;
        }
    }
}

