/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.query;

import java.lang.reflect.ParameterizedType;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.graph.GraphConverter;
import org.jnosql.artemis.graph.GraphTemplate;
import org.jnosql.artemis.graph.query.AbstractGraphRepository;
import org.jnosql.artemis.graph.query.AbstractGraphRepositoryProxy;
import org.jnosql.artemis.graph.query.GraphQueryParser;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

class GraphRepositoryProxy<T, ID>
extends AbstractGraphRepositoryProxy<T, ID> {
    private final GraphRepository repository;
    private final Reflections reflections;
    private final ClassRepresentation classRepresentation;
    private final GraphQueryParser queryParser;
    private final Graph graph;
    private final GraphConverter converter;
    private final GraphTemplate template;

    GraphRepositoryProxy(GraphTemplate template, ClassRepresentations classRepresentations, Class<?> repositoryType, Reflections reflections, Graph graph, GraphConverter converter) {
        Class typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.graph = graph;
        this.converter = converter;
        this.reflections = reflections;
        this.classRepresentation = classRepresentations.get(typeClass);
        this.queryParser = new GraphQueryParser();
        this.repository = new GraphRepository(template, this.classRepresentation);
        this.template = template;
    }

    @Override
    protected ClassRepresentation getClassRepresentation() {
        return this.classRepresentation;
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected GraphQueryParser getQueryParser() {
        return this.queryParser;
    }

    @Override
    protected Graph getGraph() {
        return this.graph;
    }

    @Override
    protected GraphConverter getConverter() {
        return this.converter;
    }

    @Override
    protected GraphTemplate getTemplate() {
        return this.template;
    }

    class GraphRepository
    extends AbstractGraphRepository
    implements Repository {
        private final GraphTemplate template;
        private final ClassRepresentation classRepresentation;

        GraphRepository(GraphTemplate template, ClassRepresentation classRepresentation) {
            this.template = template;
            this.classRepresentation = classRepresentation;
        }

        @Override
        protected GraphTemplate getTemplate() {
            return this.template;
        }

        @Override
        protected ClassRepresentation getClassRepresentation() {
            return this.classRepresentation;
        }

        @Override
        protected Reflections getReflections() {
            return GraphRepositoryProxy.this.reflections;
        }
    }
}

