/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.query;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.jnosql.artemis.Query;

public enum GraphRepositoryType {
    DEFAULT,
    FIND_ALL,
    FIND_BY,
    DELETE_BY,
    UNKNOWN,
    OBJECT_METHOD,
    JNOSQL_QUERY;

    private static final Method[] METHODS;

    static GraphRepositoryType of(Method method, Object[] args) {
        String methodName;
        if (Stream.of(METHODS).anyMatch(method::equals)) {
            return OBJECT_METHOD;
        }
        if (Objects.nonNull(method.getAnnotation(Query.class))) {
            return JNOSQL_QUERY;
        }
        switch (methodName = method.getName()) {
            case "save": 
            case "deleteById": 
            case "delete": 
            case "findById": 
            case "existsById": {
                return DEFAULT;
            }
            case "findAll": {
                return FIND_ALL;
            }
        }
        if (methodName.startsWith("findBy")) {
            return FIND_BY;
        }
        if (methodName.startsWith("deleteBy")) {
            return DELETE_BY;
        }
        return UNKNOWN;
    }

    static {
        METHODS = Object.class.getMethods();
    }
}

