/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.query;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jnosql.diana.api.NonUniqueResultException;

final class ReturnTypeConverterUtil {
    private ReturnTypeConverterUtil() {
    }

    public static Object returnObject(Stream stream, Class typeClass, Method method) {
        Class<?> returnType = method.getReturnType();
        if (typeClass.equals(returnType)) {
            Optional<Object> optional = stream.findFirst();
            return optional.orElse(null);
        }
        if (Optional.class.equals(returnType)) {
            return stream.findFirst();
        }
        if (List.class.equals(returnType) || Iterable.class.equals(returnType) || Collection.class.equals(returnType)) {
            return stream.collect(Collectors.toList());
        }
        if (Set.class.equals(returnType)) {
            return stream.collect(Collectors.toSet());
        }
        if (Queue.class.equals(returnType)) {
            return stream.collect(Collectors.toCollection(PriorityQueue::new));
        }
        if (Stream.class.equals(returnType)) {
            return stream;
        }
        return stream;
    }

    static <T> Object returnObject(List<T> entities, Class<?> typeClass, Method method) {
        Class<?> returnType = method.getReturnType();
        if (typeClass.equals(returnType)) {
            return ReturnTypeConverterUtil.getObject(entities, method);
        }
        if (Optional.class.equals(returnType)) {
            return Optional.ofNullable(ReturnTypeConverterUtil.getObject(entities, method));
        }
        if (List.class.equals(returnType) || Iterable.class.equals(returnType) || Collection.class.equals(returnType)) {
            return entities;
        }
        if (Set.class.equals(returnType)) {
            return new HashSet<T>(entities);
        }
        if (Queue.class.equals(returnType)) {
            return new PriorityQueue<T>(entities);
        }
        if (Stream.class.equals(returnType)) {
            return entities.stream();
        }
        return entities;
    }

    private static <T> Object getObject(List<T> entities, Method method) {
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() == 1) {
            return entities.get(0);
        }
        throw new NonUniqueResultException("No unique result to the method: " + method);
    }
}

