/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.query;

import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.jnosql.artemis.DynamicQueryException;
import org.jnosql.artemis.graph.query.TokenProcessor;
import org.jnosql.artemis.reflection.ClassRepresentation;

enum TokenProcessorType implements TokenProcessor
{
    BETWEEN("Between"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            TokenProcessorType.checkContents(index, args.length, 2, methodName);
            String name = TokenProcessorType.getName(token, representation).replace(this.getType(), "");
            return traversal.has(name, P.between((Object)args[index], (Object)args[++index]));
        }
    }
    ,
    OUT_V("OutV"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            if (this.getType().equals(token)) {
                TokenProcessorType.checkContents(index, args.length, 1, methodName);
                return traversal.out(new String[]{args[index].toString()});
            }
            String label = TokenProcessorType.getName(token).replace(this.getType(), "");
            return traversal.out(new String[]{label});
        }
    }
    ,
    IN_V("InV"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            if (this.getType().equals(token)) {
                TokenProcessorType.checkContents(index, args.length, 1, methodName);
                return traversal.in(new String[]{args[index].toString()});
            }
            String label = TokenProcessorType.getName(token).replace(this.getType(), "");
            return traversal.in(new String[]{label});
        }
    }
    ,
    BOTH_V("BothV"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            if (this.getType().equals(token)) {
                TokenProcessorType.checkContents(index, args.length, 1, methodName);
                return traversal.both(new String[]{args[index].toString()});
            }
            String label = TokenProcessorType.getName(token).replace(this.getType(), "");
            return traversal.both(new String[]{label});
        }
    }
    ,
    LESSA_THAN_EQUAL("LessThanEqual"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            TokenProcessorType.checkContents(index, args.length, 1, methodName);
            String name = TokenProcessorType.getName(token, representation).replace(this.getType(), "");
            return traversal.has(name, P.lte((Object)args[index]));
        }
    }
    ,
    GREATER_THAN_EQUAL("GreaterThanEqual"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            TokenProcessorType.checkContents(index, args.length, 1, methodName);
            String name = TokenProcessorType.getName(token, representation).replace(this.getType(), "");
            return traversal.has(name, P.gte((Object)args[index]));
        }
    }
    ,
    LESS_THAN("LessThan"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            TokenProcessorType.checkContents(index, args.length, 1, methodName);
            String name = TokenProcessorType.getName(token, representation).replace(this.getType(), "");
            return traversal.has(name, P.lt((Object)args[index]));
        }
    }
    ,
    GREATER_THAN("GreaterThan"){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            TokenProcessorType.checkContents(index, args.length, 1, methodName);
            String name = TokenProcessorType.getName(token, representation).replace(this.getType(), "");
            return traversal.has(name, P.gt((Object)args[index]));
        }
    }
    ,
    DEFAULT(""){

        @Override
        public GraphTraversal<?, ?> process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, GraphTraversal<?, ?> traversal) {
            TokenProcessorType.checkContents(index, args.length, 1, methodName);
            String name = TokenProcessorType.getName(token, representation);
            return traversal.has(name, args[index]);
        }
    };

    private final String type;

    private TokenProcessorType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    private static void checkContents(int index, int argSize, int required, String method) {
        if (index + required <= argSize) {
            return;
        }
        throw new DynamicQueryException(String.format("There is a missed argument in the method %s", method));
    }

    private static String getName(String token, ClassRepresentation representation) {
        return representation.getColumnField(TokenProcessorType.getName(token));
    }

    private static String getName(String token) {
        return String.valueOf(Character.toLowerCase(token.charAt(0))).concat(token.substring(1));
    }

    static TokenProcessor of(String token) {
        return Stream.of(TokenProcessorType.values()).filter(t -> token.contains(t.getType())).findFirst().orElse(DEFAULT);
    }

    static boolean isGraphToken(String token) {
        return Stream.of(OUT_V, IN_V, BOTH_V).anyMatch(t -> token.contains(t.getType()));
    }

    static boolean isNotGraphToken(String token) {
        return !TokenProcessorType.isGraphToken(token);
    }

    static boolean isBetweenToken(String token) {
        return BETWEEN.getType().contains(token);
    }
}

