/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.spi;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jnosql.artemis.DatabaseMetadata;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.Databases;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.graph.query.RepositoryGraphBean;
import org.jnosql.artemis.graph.spi.GraphTemplateBean;

public class GraphProducerExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(GraphProducerExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();
    private final Collection<Class<?>> crudTypes = new HashSet();

    <T extends Repository> void onProcessAnnotatedType(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (Repository.class.equals((Object)javaClass)) {
            return;
        }
        if (Stream.of(javaClass.getInterfaces()).anyMatch(Repository.class::equals) && Modifier.isInterface(javaClass.getModifiers())) {
            LOGGER.info("Adding a new Repository as discovered on Graph: " + javaClass);
            this.crudTypes.add(javaClass);
        }
    }

    <T, X extends Graph> void processProducer(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.GRAPH, this.databases);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        LOGGER.info(String.format("Starting to process on graphs: %d databases crud %d", this.databases.size(), this.crudTypes.size()));
        this.databases.forEach(type -> {
            GraphTemplateBean bean = new GraphTemplateBean(beanManager, type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_GRAPH)) {
                afterBeanDiscovery.addBean((Bean)new RepositoryGraphBean((Class)type, beanManager, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean((Bean)new RepositoryGraphBean((Class)type, beanManager, database.getProvider())));
        });
    }
}

