/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.graph.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jnosql.artemis.DatabaseQualifier;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.graph.GraphTemplate;
import org.jnosql.artemis.graph.GraphTemplateProducer;

class GraphTemplateBean
implements Bean<GraphTemplate>,
PassivationCapable {
    private final BeanManager beanManager;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public GraphTemplateBean(BeanManager beanManager, String provider) {
        this.beanManager = beanManager;
        this.types = Collections.singleton(GraphTemplate.class);
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofGraph((String)provider));
    }

    public Class<?> getBeanClass() {
        return GraphTemplate.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public GraphTemplate create(CreationalContext<GraphTemplate> creationalContext) {
        GraphTemplateProducer producer = this.getInstance(GraphTemplateProducer.class);
        Graph manager = this.getGraph();
        return producer.get(manager);
    }

    private Graph getGraph() {
        Bean bean = (Bean)this.beanManager.getBeans(Graph.class, new Annotation[]{DatabaseQualifier.ofGraph((String)this.provider)}).iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (Graph)this.beanManager.getReference(bean, Graph.class, ctx);
    }

    private <T> T getInstance(Class<T> clazz) {
        Bean bean = (Bean)this.beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, ctx);
    }

    public void destroy(GraphTemplate instance, CreationalContext<GraphTemplate> creationalContext) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return GraphTemplate.class.getName() + DatabaseType.COLUMN + "-" + this.provider;
    }
}

