/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import jodd.log.Logger;
import jodd.log.impl.SimpleLoggerFactory;

public class SimpleLogger
implements Logger {
    private final String name;
    private final SimpleLoggerFactory slf;

    public SimpleLogger(SimpleLoggerFactory simpleLoggerFactory, String name) {
        this.name = name;
        this.slf = simpleLoggerFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return level.isEnabledFor(this.slf.getLevel());
    }

    @Override
    public void log(Logger.Level level, String message) {
        this.print(level, message, null);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.Level.TRACE.isEnabledFor(this.slf.getLevel());
    }

    @Override
    public void trace(String message) {
        this.print(Logger.Level.TRACE, message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logger.Level.DEBUG.isEnabledFor(this.slf.getLevel());
    }

    @Override
    public void debug(String message) {
        this.print(Logger.Level.DEBUG, message, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return Logger.Level.INFO.isEnabledFor(this.slf.getLevel());
    }

    @Override
    public void info(String message) {
        this.print(Logger.Level.INFO, message, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return Logger.Level.WARN.isEnabledFor(this.slf.getLevel());
    }

    @Override
    public void warn(String message) {
        this.print(Logger.Level.WARN, message, null);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.print(Logger.Level.WARN, message, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return Logger.Level.ERROR.isEnabledFor(this.slf.getLevel());
    }

    @Override
    public void error(String message) {
        this.print(Logger.Level.ERROR, message, null);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.print(Logger.Level.ERROR, message, throwable);
    }

    protected void print(Logger.Level level, String message, Throwable throwable) {
        if (!this.isEnabled(level)) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(this.slf.getElapsedTime());
        msg.append(' ');
        msg.append('[');
        msg.append(level.toString());
        msg.append(']');
        msg.append(' ');
        msg.append(this.slf.getCallerClass());
        msg.append(' ');
        msg.append('-');
        msg.append(' ');
        msg.append(message);
        System.out.println(msg.toString());
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }
}

