
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NumberAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "confusionMatrix",
    "liftDatas",
    "roc"
})
@XmlRootElement(name = "PredictiveModelQuality", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "targetField",
    "dataName",
    "dataUsage",
    "meanError",
    "meanAbsoluteError",
    "meanSquaredError",
    "rootMeanSquaredError",
    "rSquared",
    "adjRSquared",
    "sumSquaredError",
    "sumSquaredRegression",
    "numOfRecords",
    "numOfRecordsWeighted",
    "numOfPredictors",
    "degreesOfFreedom",
    "fStatistic",
    "aic",
    "bic",
    "aiCc",
    "extensions",
    "confusionMatrix",
    "liftDatas",
    "roc"
})
public class PredictiveModelQuality
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PredictiveModelQuality>
{

    @XmlAttribute(name = "targetField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("targetField")
    private FieldName targetField;
    @XmlAttribute(name = "dataName")
    @JsonProperty("dataName")
    private String dataName;
    @XmlAttribute(name = "dataUsage")
    @JsonProperty("dataUsage")
    private PredictiveModelQuality.DataUsage dataUsage;
    @XmlAttribute(name = "meanError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("meanError")
    private Number meanError;
    @XmlAttribute(name = "meanAbsoluteError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("meanAbsoluteError")
    private Number meanAbsoluteError;
    @XmlAttribute(name = "meanSquaredError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("meanSquaredError")
    private Number meanSquaredError;
    @XmlAttribute(name = "rootMeanSquaredError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("rootMeanSquaredError")
    private Number rootMeanSquaredError;
    @XmlAttribute(name = "r-squared")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("r-squared")
    private Number rSquared;
    @XmlAttribute(name = "adj-r-squared")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("adj-r-squared")
    private Number adjRSquared;
    @XmlAttribute(name = "sumSquaredError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("sumSquaredError")
    private Number sumSquaredError;
    @XmlAttribute(name = "sumSquaredRegression")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("sumSquaredRegression")
    private Number sumSquaredRegression;
    @XmlAttribute(name = "numOfRecords")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("numOfRecords")
    private Number numOfRecords;
    @XmlAttribute(name = "numOfRecordsWeighted")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("numOfRecordsWeighted")
    private Number numOfRecordsWeighted;
    @XmlAttribute(name = "numOfPredictors")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("numOfPredictors")
    private Number numOfPredictors;
    @XmlAttribute(name = "degreesOfFreedom")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("degreesOfFreedom")
    private Number degreesOfFreedom;
    @XmlAttribute(name = "fStatistic")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("fStatistic")
    private Number fStatistic;
    @XmlAttribute(name = "AIC")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("AIC")
    private Number aic;
    @XmlAttribute(name = "BIC")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("BIC")
    private Number bic;
    @XmlAttribute(name = "AICc")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("AICc")
    private Number aiCc;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ConfusionMatrix")
    private ConfusionMatrix confusionMatrix;
    @XmlElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LiftData")
    private List<LiftData> liftDatas;
    @XmlElement(name = "ROC", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ROC")
    private ROC roc;
    private final static long serialVersionUID = 67305489L;

    public PredictiveModelQuality() {
    }

    public PredictiveModelQuality(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
    }

    public FieldName getTargetField() {
        return targetField;
    }

    public PredictiveModelQuality setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    public String getDataName() {
        return dataName;
    }

    public PredictiveModelQuality setDataName(
        @org.jpmml.model.annotations.Property("dataName")
        String dataName) {
        this.dataName = dataName;
        return this;
    }

    public PredictiveModelQuality.DataUsage getDataUsage() {
        if (dataUsage == null) {
            return PredictiveModelQuality.DataUsage.TRAINING;
        } else {
            return dataUsage;
        }
    }

    public PredictiveModelQuality setDataUsage(
        @org.jpmml.model.annotations.Property("dataUsage")
        PredictiveModelQuality.DataUsage dataUsage) {
        this.dataUsage = dataUsage;
        return this;
    }

    public Number getMeanError() {
        return meanError;
    }

    public PredictiveModelQuality setMeanError(
        @org.jpmml.model.annotations.Property("meanError")
        Number meanError) {
        this.meanError = meanError;
        return this;
    }

    public Number getMeanAbsoluteError() {
        return meanAbsoluteError;
    }

    public PredictiveModelQuality setMeanAbsoluteError(
        @org.jpmml.model.annotations.Property("meanAbsoluteError")
        Number meanAbsoluteError) {
        this.meanAbsoluteError = meanAbsoluteError;
        return this;
    }

    public Number getMeanSquaredError() {
        return meanSquaredError;
    }

    public PredictiveModelQuality setMeanSquaredError(
        @org.jpmml.model.annotations.Property("meanSquaredError")
        Number meanSquaredError) {
        this.meanSquaredError = meanSquaredError;
        return this;
    }

    public Number getRootMeanSquaredError() {
        return rootMeanSquaredError;
    }

    public PredictiveModelQuality setRootMeanSquaredError(
        @org.jpmml.model.annotations.Property("rootMeanSquaredError")
        Number rootMeanSquaredError) {
        this.rootMeanSquaredError = rootMeanSquaredError;
        return this;
    }

    public Number getRSquared() {
        return rSquared;
    }

    public PredictiveModelQuality setRSquared(
        @org.jpmml.model.annotations.Property("rSquared")
        Number rSquared) {
        this.rSquared = rSquared;
        return this;
    }

    public Number getAdjRSquared() {
        return adjRSquared;
    }

    public PredictiveModelQuality setAdjRSquared(
        @org.jpmml.model.annotations.Property("adjRSquared")
        Number adjRSquared) {
        this.adjRSquared = adjRSquared;
        return this;
    }

    public Number getSumSquaredError() {
        return sumSquaredError;
    }

    public PredictiveModelQuality setSumSquaredError(
        @org.jpmml.model.annotations.Property("sumSquaredError")
        Number sumSquaredError) {
        this.sumSquaredError = sumSquaredError;
        return this;
    }

    public Number getSumSquaredRegression() {
        return sumSquaredRegression;
    }

    public PredictiveModelQuality setSumSquaredRegression(
        @org.jpmml.model.annotations.Property("sumSquaredRegression")
        Number sumSquaredRegression) {
        this.sumSquaredRegression = sumSquaredRegression;
        return this;
    }

    public Number getNumOfRecords() {
        return numOfRecords;
    }

    public PredictiveModelQuality setNumOfRecords(
        @org.jpmml.model.annotations.Property("numOfRecords")
        Number numOfRecords) {
        this.numOfRecords = numOfRecords;
        return this;
    }

    public Number getNumOfRecordsWeighted() {
        return numOfRecordsWeighted;
    }

    public PredictiveModelQuality setNumOfRecordsWeighted(
        @org.jpmml.model.annotations.Property("numOfRecordsWeighted")
        Number numOfRecordsWeighted) {
        this.numOfRecordsWeighted = numOfRecordsWeighted;
        return this;
    }

    public Number getNumOfPredictors() {
        return numOfPredictors;
    }

    public PredictiveModelQuality setNumOfPredictors(
        @org.jpmml.model.annotations.Property("numOfPredictors")
        Number numOfPredictors) {
        this.numOfPredictors = numOfPredictors;
        return this;
    }

    public Number getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    public PredictiveModelQuality setDegreesOfFreedom(
        @org.jpmml.model.annotations.Property("degreesOfFreedom")
        Number degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
        return this;
    }

    public Number getFStatistic() {
        return fStatistic;
    }

    public PredictiveModelQuality setFStatistic(
        @org.jpmml.model.annotations.Property("fStatistic")
        Number fStatistic) {
        this.fStatistic = fStatistic;
        return this;
    }

    public Number getAIC() {
        return aic;
    }

    public PredictiveModelQuality setAIC(
        @org.jpmml.model.annotations.Property("aic")
        Number aic) {
        this.aic = aic;
        return this;
    }

    public Number getBIC() {
        return bic;
    }

    public PredictiveModelQuality setBIC(
        @org.jpmml.model.annotations.Property("bic")
        Number bic) {
        this.bic = bic;
        return this;
    }

    public Number getAICc() {
        return aiCc;
    }

    public PredictiveModelQuality setAICc(
        @org.jpmml.model.annotations.Property("aiCc")
        Number aiCc) {
        this.aiCc = aiCc;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PredictiveModelQuality addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ConfusionMatrix getConfusionMatrix() {
        return confusionMatrix;
    }

    public PredictiveModelQuality setConfusionMatrix(
        @org.jpmml.model.annotations.Property("confusionMatrix")
        ConfusionMatrix confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
        return this;
    }

    public boolean hasLiftDatas() {
        return ((this.liftDatas!= null)&&(this.liftDatas.size()> 0));
    }

    public List<LiftData> getLiftDatas() {
        if (liftDatas == null) {
            liftDatas = new ArrayList<LiftData>();
        }
        return this.liftDatas;
    }

    public PredictiveModelQuality addLiftDatas(LiftData... liftDatas) {
        getLiftDatas().addAll(Arrays.asList(liftDatas));
        return this;
    }

    public ROC getROC() {
        return roc;
    }

    public PredictiveModelQuality setROC(
        @org.jpmml.model.annotations.Property("roc")
        ROC roc) {
        this.roc = roc;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getConfusionMatrix());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLiftDatas()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLiftDatas());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getROC());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum DataUsage
        implements StringValue<PredictiveModelQuality.DataUsage>
    {

        @XmlEnumValue("training")
        @JsonProperty("training")
        TRAINING("training"),
        @XmlEnumValue("test")
        @JsonProperty("test")
        TEST("test"),
        @XmlEnumValue("validation")
        @JsonProperty("validation")
        VALIDATION("validation");
        private final String value;

        DataUsage(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static PredictiveModelQuality.DataUsage fromValue(String v) {
            for (PredictiveModelQuality.DataUsage c: PredictiveModelQuality.DataUsage.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
