
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "lower",
    "upper"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "lower",
    "upper"
})
public class UniformDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<UniformDistribution>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Lower", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Lower")
    private Lower lower;
    @XmlElement(name = "Upper", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Upper")
    private Upper upper;
    private final static long serialVersionUID = 67305489L;

    public UniformDistribution() {
    }

    public UniformDistribution(
        @org.jpmml.model.annotations.Property("lower")
        Lower lower,
        @org.jpmml.model.annotations.Property("upper")
        Upper upper) {
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public UniformDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Lower getLower() {
        return lower;
    }

    public UniformDistribution setLower(
        @org.jpmml.model.annotations.Property("lower")
        Lower lower) {
        this.lower = lower;
        return this;
    }

    public Upper getUpper() {
        return upper;
    }

    public UniformDistribution setUpper(
        @org.jpmml.model.annotations.Property("upper")
        Upper upper) {
        this.upper = upper;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLower(), getUpper());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
