
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "sequenceReference",
    "time"
})
@XmlRootElement(name = "AntecedentSequence", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "sequenceReference",
    "time"
})
public class AntecedentSequence
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<AntecedentSequence>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "SequenceReference", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("SequenceReference")
    private SequenceReference sequenceReference;
    @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Time")
    private Time time;
    private final static long serialVersionUID = 67305489L;

    public AntecedentSequence() {
    }

    public AntecedentSequence(
        @org.jpmml.model.annotations.Property("sequenceReference")
        SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AntecedentSequence addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public SequenceReference getSequenceReference() {
        return sequenceReference;
    }

    public AntecedentSequence setSequenceReference(
        @org.jpmml.model.annotations.Property("sequenceReference")
        SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
        return this;
    }

    public Time getTime() {
        return time;
    }

    public AntecedentSequence setTime(
        @org.jpmml.model.annotations.Property("time")
        Time time) {
        this.time = time;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSequenceReference(), getTime());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
