
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Deprecated;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "textDictionary",
    "textCorpus",
    "documentTermMatrix",
    "textModelNormalization",
    "textModelSimiliarity",
    "modelVerification"
})
@XmlRootElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_3")
@Deprecated((org.dmg.pmml.Version.PMML_4_2))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "numberOfTerms",
    "numberOfDocuments",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "textDictionary",
    "textCorpus",
    "documentTermMatrix",
    "textModelNormalization",
    "textModelSimiliarity",
    "modelVerification"
})
public class TextModel
    extends Model
    implements HasExtensions<TextModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTerms", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("numberOfTerms")
    private Integer numberOfTerms;
    @XmlAttribute(name = "numberOfDocuments", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("numberOfDocuments")
    private Integer numberOfDocuments;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TextDictionary", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("TextDictionary")
    private TextDictionary textDictionary;
    @XmlElement(name = "TextCorpus", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("TextCorpus")
    private TextCorpus textCorpus;
    @XmlElement(name = "DocumentTermMatrix", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("DocumentTermMatrix")
    private DocumentTermMatrix documentTermMatrix;
    @XmlElement(name = "TextModelNormalization", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("TextModelNormalization")
    private TextModelNormalization textModelNormalization;
    @XmlElement(name = "TextModelSimiliarity", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("TextModelSimiliarity")
    private TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305489L;

    public TextModel() {
    }

    public TextModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("numberOfTerms")
        Integer numberOfTerms,
        @org.jpmml.model.annotations.Property("numberOfDocuments")
        Integer numberOfDocuments,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("textDictionary")
        TextDictionary textDictionary,
        @org.jpmml.model.annotations.Property("textCorpus")
        TextCorpus textCorpus,
        @org.jpmml.model.annotations.Property("documentTermMatrix")
        DocumentTermMatrix documentTermMatrix) {
        this.miningFunction = miningFunction;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
    }

    public String getModelName() {
        return modelName;
    }

    public TextModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public TextModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public TextModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTerms() {
        return numberOfTerms;
    }

    public TextModel setNumberOfTerms(
        @org.jpmml.model.annotations.Property("numberOfTerms")
        Integer numberOfTerms) {
        this.numberOfTerms = numberOfTerms;
        return this;
    }

    public Integer getNumberOfDocuments() {
        return numberOfDocuments;
    }

    public TextModel setNumberOfDocuments(
        @org.jpmml.model.annotations.Property("numberOfDocuments")
        Integer numberOfDocuments) {
        this.numberOfDocuments = numberOfDocuments;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public TextModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public TextModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public TextModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public TextModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public TextModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public TextModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public TextModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public TextModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TextDictionary getTextDictionary() {
        return textDictionary;
    }

    public TextModel setTextDictionary(
        @org.jpmml.model.annotations.Property("textDictionary")
        TextDictionary textDictionary) {
        this.textDictionary = textDictionary;
        return this;
    }

    public TextCorpus getTextCorpus() {
        return textCorpus;
    }

    public TextModel setTextCorpus(
        @org.jpmml.model.annotations.Property("textCorpus")
        TextCorpus textCorpus) {
        this.textCorpus = textCorpus;
        return this;
    }

    public DocumentTermMatrix getDocumentTermMatrix() {
        return documentTermMatrix;
    }

    public TextModel setDocumentTermMatrix(
        @org.jpmml.model.annotations.Property("documentTermMatrix")
        DocumentTermMatrix documentTermMatrix) {
        this.documentTermMatrix = documentTermMatrix;
        return this;
    }

    public TextModelNormalization getTextModelNormalization() {
        return textModelNormalization;
    }

    public TextModel setTextModelNormalization(
        @org.jpmml.model.annotations.Property("textModelNormalization")
        TextModelNormalization textModelNormalization) {
        this.textModelNormalization = textModelNormalization;
        return this;
    }

    public TextModelSimiliarity getTextModelSimiliarity() {
        return textModelSimiliarity;
    }

    public TextModel setTextModelSimiliarity(
        @org.jpmml.model.annotations.Property("textModelSimiliarity")
        TextModelSimiliarity textModelSimiliarity) {
        this.textModelSimiliarity = textModelSimiliarity;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public TextModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTextDictionary(), getTextCorpus(), getDocumentTermMatrix(), getTextModelNormalization(), getTextModelSimiliarity(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
