/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class SimpleCallbackMethod
extends DynamicMethod {
    private Callback callback;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SimpleCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility);
        this.callback = callback;
    }

    public void preMethod(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
    }

    public void postMethod(ThreadContext context) {
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError();
        }
        Ruby runtime = context.getRuntime();
        if (runtime.getTraceFunction() != null) {
            ISourcePosition position = context.getPosition();
            runtime.callTraceFunction(context, "c-call", position, self, name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.callback.execute(self, args, Block.NULL_BLOCK);
                return iRubyObject;
            }
            finally {
                runtime.callTraceFunction(context, "c-return", position, self, name, this.getImplementationClass());
            }
        }
        return this.callback.execute(self, args, Block.NULL_BLOCK);
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Arity getArity() {
        return this.getCallback().getArity();
    }

    public DynamicMethod dup() {
        return new SimpleCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }

    static {
        $assertionsDisabled = !SimpleCallbackMethod.class.desiredAssertionStatus();
    }
}

