/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby runtime2) {
        RubyModule module = runtime2.defineModule("Marshal");
        runtime2.setMarshal(module);
        module.defineAnnotatedMethods(RubyMarshal.class);
        module.defineConstant("MAJOR_VERSION", runtime2.newFixnum(4));
        module.defineConstant("MINOR_VERSION", runtime2.newFixnum(8));
        return module;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=2, frame=true, module=true)
    public static IRubyObject dump(IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        if (args2.length < 1) {
            throw recv2.getRuntime().newArgumentError("wrong # of arguments(at least 1)");
        }
        IRubyObject objectToDump = args2[0];
        IRubyObject io2 = null;
        int depthLimit = -1;
        if (args2.length >= 2) {
            if (args2[1].respondsTo("write")) {
                io2 = args2[1];
            } else if (args2[1] instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)args2[1]).getLongValue();
            } else {
                throw recv2.getRuntime().newTypeError("Instance of IO needed");
            }
            if (args2.length == 3) {
                depthLimit = (int)args2[2].convertToInteger().getLongValue();
            }
        }
        try {
            if (io2 != null) {
                RubyMarshal.dumpToStream(objectToDump, RubyMarshal.outputStream(io2), depthLimit);
                return io2;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            boolean taint2 = RubyMarshal.dumpToStream(objectToDump, stringOutput, depthLimit);
            RubyString result = RubyString.newString(recv2.getRuntime(), new ByteList(stringOutput.toByteArray(), false));
            if (taint2) {
                result.setTaint(true);
            }
            return result;
        }
        catch (IOException ioe) {
            throw recv2.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static OutputStream outputStream(IRubyObject out) {
        RubyMarshal.setBinmodeIfPossible(out);
        return new IOOutputStream(out);
    }

    private static void setBinmodeIfPossible(IRubyObject io2) {
        if (io2.respondsTo("binmode")) {
            io2.callMethod(io2.getRuntime().getCurrentContext(), "binmode");
        }
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, frame=true, module=true)
    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        IRubyObject in = null;
        IRubyObject proc2 = null;
        try {
            InputStream rawInput;
            if (args2.length < 1) {
                throw recv2.getRuntime().newArgumentError("wrong number of arguments (0 for 1)");
            }
            if (args2.length > 2) {
                throw recv2.getRuntime().newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
            }
            switch (args2.length) {
                case 2: {
                    proc2 = args2[1];
                }
                case 1: {
                    in = args2[0];
                }
            }
            boolean tainted = false;
            IRubyObject v = in.checkStringType();
            if (!v.isNil()) {
                tainted = in.isTaint();
                ByteList bytes2 = ((RubyString)v).getByteList();
                rawInput = new ByteArrayInputStream(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
            } else if (in.respondsTo("getc") && in.respondsTo("read")) {
                if (in.respondsTo("binmode")) {
                    RuntimeHelpers.invoke(context, in, "binmode");
                }
                tainted = true;
                rawInput = RubyMarshal.inputStream(in);
            } else {
                throw recv2.getRuntime().newTypeError("instance of IO needed");
            }
            UnmarshalStream input = new UnmarshalStream(recv2.getRuntime(), rawInput, proc2, tainted);
            return input.unmarshalObject();
        }
        catch (EOFException ee) {
            if (in != null && in.respondsTo("to_str")) {
                throw recv2.getRuntime().newArgumentError("marshal data too short");
            }
            throw recv2.getRuntime().newEOFError();
        }
        catch (IOException ioe) {
            throw recv2.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static InputStream inputStream(IRubyObject in) {
        RubyMarshal.setBinmodeIfPossible(in);
        return new IOInputStream(in);
    }

    private static boolean dumpToStream(IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(object.getRuntime(), rawOutput, depthLimit);
        output.dumpObject(object);
        return output.isTainted();
    }
}

